set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9531493';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3213',
      '23332400',
      '04321410',
      '44332100',
      '14134304',
      '41410131',
      NULL,
      '23100213',
      '31231110',
      '13203024',
      '41014142',
      NULL,
      NULL,
      '31402434',
      '02430113',
      '00424303',
      '21420223',
      '03003112',
      '23004021',
      '32304243',
      '24403213',
      '32113133',
      '22302210',
      NULL,
      NULL,
      '14233133',
      '13134133',
      '21340122',
      '10202024',
      '42204413',
      '33422014',
      NULL,
      '01103023',
      '40221204',
      NULL,
      '33242401',
      '21444443',
      NULL,
      NULL,
      NULL,
      '10224414',
      '20234230',
      '22421001',
      '03210413',
      '31311443',
      '333',
      '10',
      NULL,
      10,
      NULL,
      0.885533,
      5.132791,
      1,
      NULL,
      '210323',
      0.969954,
      ' 9- 7-1988',
      NULL,
      142,
      79.716186,
      41.082890,
      27,
      10.706399,
      9,
      95.118080,
      12.271394,
      21,
      13,
      0,
      5.772313,
      5,
      16,
      23.782349,
      29,
      NULL,
      17.602425,
      4,
      24.997792,
      16,
      13,
      71,
      24,
      0.353173,
      132,
      93.032139,
      93,
      NULL,
      55,
      17,
      ' 3- 5-1984',
      31,
      NULL,
      NULL,
      31.509168,
      NULL,
      150.566407,
      ' 1-27-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      108.093599,
      NULL,
      NULL,
      0.631914,
      0.331496,
      NULL,
      ' 0- 0-1997',
      1.613030,
      NULL,
      206.694019,
      1,
      0.095783,
      80.988799,
      0,
      2,
      91,
      NULL,
      NULL,
      NULL,
      ' 0- 3-1991',
      39,
      87,
      11,
      NULL,
      8.029243,
      65,
      34,
      100,
      54,
      NULL,
      101,
      78,
      NULL,
      15.013226,
      22,
      2,
      NULL,
      NULL,
      107,
      0,
      ' 3- 3-1975',
      28,
      18.436662,
      ' 6- 1-1979',
      1.582206,
      NULL,
      17,
      19,
      3,
      15.988643,
      0,
      14,
      NULL,
      NULL,
      0.215021,
      5,
      19.989106,
      NULL,
      0.448923,
      0.970462,
      1,
      0.963548,
      '10-19-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.136135,
      '11-27-1976',
      NULL,
      NULL,
      NULL,
      59.129532,
      ' 3-12-2002',
      12.281538,
      ' 8- 2-1999',
      2,
      3.813318,
      ' 0- 8-1981',
      51,
      77.968746,
      ' 8-10-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.021102,
      ' 7- 8-1983',
      8,
      52,
      19,
      ' 3-25-1982',
      NULL,
      10.542362,
      ' 2- 8-1978',
      17.580718,
      31,
      NULL,
      10.707267,
      ' 5- 6-1976',
      39.891425,
      0.168897,
      NULL,
      ' 7-29-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


