set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6909717';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '4',
      '4',
      '3',
      '2',
      '1',
      '3',
      '4',
      NULL,
      '3',
      '3',
      '3',
      NULL,
      '3',
      NULL,
      '4',
      '1',
      '2',
      NULL,
      '4',
      '0',
      '0',
      '3',
      NULL,
      '',
      '2',
      '',
      '1',
      '1',
      '2',
      NULL,
      '3',
      '',
      '',
      '2',
      '3',
      NULL,
      '1',
      '2',
      '2',
      '2',
      '3',
      '1',
      '4',
      '2',
      '130',
      '01132412',
      8,
      24,
      '2113212',
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.257750,
      ' 0-15-1996',
      ' 9-17-2002',
      14,
      236.964592,
      NULL,
      11.616847,
      5,
      5.488593,
      75.891411,
      20,
      13,
      9.389825,
      7,
      3.396829,
      5,
      NULL,
      9.378973,
      12,
      19,
      0,
      10,
      10,
      32,
      NULL,
      51,
      3,
      1.730049,
      55.082637,
      50,
      44,
      NULL,
      30,
      159,
      ' 0- 9-1977',
      26,
      56.761760,
      3,
      33.047953,
      NULL,
      NULL,
      ' 4-15-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      53.971190,
      6,
      16,
      2.426084,
      13,
      6.355006,
      ' 7-11-2003',
      1.765326,
      1,
      NULL,
      1,
      0.891570,
      NULL,
      2.224626,
      NULL,
      21.256597,
      NULL,
      NULL,
      NULL,
      ' 1- 1-1988',
      NULL,
      63.748842,
      NULL,
      61.596960,
      74,
      88,
      8,
      80,
      79,
      6.625087,
      NULL,
      43,
      '10-29-1981',
      6.774606,
      NULL,
      15,
      NULL,
      16,
      105,
      6,
      NULL,
      NULL,
      27,
      '10- 6-1981',
      0,
      11,
      8.325512,
      14,
      2,
      4.121464,
      1.356746,
      1,
      NULL,
      54.448982,
      10.705217,
      1.586450,
      5.449687,
      12.372491,
      5.373958,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      66.521123,
      4.411715,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      35,
      '10-12-1986',
      0,
      5.568003,
      ' 1-21-1978',
      71,
      30,
      ' 2- 7-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      34.824108,
      11,
      4.472875,
      NULL,
      0.908044,
      162.648076,
      ' 1-23-2000',
      14,
      NULL,
      19.298049,
      NULL,
      '10-20-2001',
      35.012363,
      1,
      109.777939,
      ' 4-19-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


