set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6909717';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      NULL,
      '0',
      '4',
      NULL,
      NULL,
      '3',
      NULL,
      '2',
      '2',
      NULL,
      '0',
      '3',
      NULL,
      '0',
      '4',
      '3',
      '3',
      '3',
      '4',
      NULL,
      '1',
      NULL,
      '0',
      '',
      '2',
      '',
      '2',
      '2',
      '0',
      '1',
      '4',
      NULL,
      '',
      '3',
      '1',
      NULL,
      '0',
      '4',
      '0',
      NULL,
      '2',
      '0',
      '0',
      '0',
      '433',
      '03440140',
      50.722702,
      13,
      '2110044',
      2,
      NULL,
      3,
      0,
      '404243',
      1,
      ' 2-21-1991',
      ' 5-28-1995',
      134.633867,
      NULL,
      26,
      NULL,
      9,
      0,
      89,
      12,
      5.227551,
      11.081695,
      18.466821,
      10,
      10.010460,
      13.402090,
      4,
      11.667813,
      15,
      13.415766,
      NULL,
      6.695231,
      16,
      19.218317,
      NULL,
      7,
      0,
      27,
      140,
      77.613202,
      160.484537,
      169,
      NULL,
      '11- 9-1988',
      NULL,
      37,
      NULL,
      30.569862,
      NULL,
      212,
      ' 5-10-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13.407985,
      14.636740,
      3,
      6.923452,
      9,
      5,
      NULL,
      NULL,
      1,
      79.566705,
      NULL,
      0.391113,
      87.743747,
      NULL,
      1.011340,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-29-1974',
      72.817836,
      50.768410,
      88.671555,
      61,
      93,
      29.215227,
      26,
      76,
      27,
      43,
      NULL,
      61,
      ' 1-12-1986',
      NULL,
      23,
      13.608261,
      46.449822,
      6,
      NULL,
      3.157665,
      ' 2- 7-2001',
      26.146710,
      NULL,
      ' 3-12-1983',
      7.245753,
      14,
      NULL,
      12.325234,
      9,
      3.653921,
      3.922532,
      NULL,
      0,
      NULL,
      NULL,
      3.076283,
      2,
      NULL,
      3.276307,
      3,
      0,
      0.803187,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      ' 7-27-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 2-1996',
      25,
      ' 8- 9-1977',
      3.368066,
      6.770795,
      NULL,
      NULL,
      36,
      ' 1- 4-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      11.371004,
      ' 9-28-1980',
      32.501498,
      6,
      13,
      NULL,
      NULL,
      162,
      ' 4- 0-1994',
      10,
      NULL,
      5.711899,
      47,
      ' 4-26-1980',
      44.177352,
      NULL,
      45.332507,
      ' 1- 0-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


