set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9683359';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2321',
      '23104042',
      '40123223',
      NULL,
      '22432331',
      '14310302',
      '02201420',
      '24142032',
      '21122203',
      '30343324',
      '14224434',
      '33230212',
      '02232432',
      NULL,
      NULL,
      '40304223',
      '00000442',
      '41224340',
      NULL,
      '23332020',
      '13302433',
      NULL,
      '42423122',
      '21423040',
      '00103323',
      '00331342',
      '33121123',
      '24111302',
      NULL,
      '43441144',
      NULL,
      NULL,
      '32211430',
      NULL,
      '10420414',
      '31303010',
      '22313230',
      '40104014',
      '22014411',
      '14312044',
      '20234411',
      '21204322',
      NULL,
      NULL,
      NULL,
      NULL,
      '13',
      26,
      21,
      '2143411',
      2.958913,
      0,
      NULL,
      NULL,
      '201023',
      NULL,
      ' 9- 5-2000',
      NULL,
      49,
      NULL,
      16,
      11.006951,
      38.090359,
      3.883862,
      34.821222,
      1.042740,
      6,
      NULL,
      49,
      NULL,
      35,
      7,
      NULL,
      5,
      3,
      18,
      36.896152,
      NULL,
      51.825225,
      9,
      14,
      16,
      NULL,
      183,
      37.396764,
      120,
      52.697400,
      144,
      NULL,
      NULL,
      34,
      30,
      29,
      32,
      149,
      163.796424,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      104,
      NULL,
      6,
      12,
      2,
      NULL,
      ' 9-10-1995',
      0,
      1,
      188,
      1,
      NULL,
      39,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-12-1982',
      NULL,
      96,
      NULL,
      39.966122,
      NULL,
      20,
      81,
      NULL,
      30,
      54.247808,
      78.558734,
      70,
      ' 8-12-1998',
      31,
      30,
      21,
      28,
      NULL,
      NULL,
      0,
      ' 2-18-1990',
      NULL,
      6.714619,
      NULL,
      1,
      1,
      20.745796,
      9.063133,
      NULL,
      10.359511,
      1.458431,
      6.217455,
      1,
      57.994299,
      1,
      0,
      9.508531,
      30,
      1,
      0,
      NULL,
      1,
      ' 8-24-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      151.079065,
      5.440887,
      ' 3- 0-1986',
      NULL,
      NULL,
      NULL,
      4.924562,
      ' 9-12-1983',
      29.781316,
      NULL,
      13.229639,
      6,
      NULL,
      NULL,
      93.469052,
      ' 4- 4-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      NULL,
      31,
      NULL,
      23,
      '11-17-1983',
      NULL,
      43.961404,
      ' 4-19-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


