set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8128597';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      '24200303',
      '03043000',
      '12131440',
      '13433401',
      '01410040',
      '41120433',
      '40134242',
      '20324011',
      '00004404',
      NULL,
      NULL,
      '03444002',
      NULL,
      '43010244',
      '32104444',
      '40302210',
      '42242033',
      NULL,
      '02422432',
      NULL,
      '23301114',
      '41223041',
      '34322113',
      '01430144',
      NULL,
      NULL,
      NULL,
      NULL,
      '22304240',
      '21132313',
      NULL,
      NULL,
      '00303223',
      '31220142',
      '01341330',
      '40401304',
      '04110122',
      '01313240',
      '32333001',
      NULL,
      NULL,
      '411',
      '04',
      NULL,
      NULL,
      NULL,
      0.045486,
      0,
      2,
      NULL,
      '114404',
      NULL,
      ' 9-18-1990',
      ' 8-13-1985',
      9.156582,
      NULL,
      3.541157,
      NULL,
      12.493726,
      8.557817,
      95.368110,
      NULL,
      9.866392,
      4.503991,
      NULL,
      NULL,
      57.498145,
      37.071304,
      9.549481,
      4.601851,
      9,
      9.979018,
      28,
      6,
      29,
      1,
      141,
      8,
      NULL,
      92,
      28,
      NULL,
      85,
      107.473981,
      98.851043,
      NULL,
      3,
      29.994060,
      NULL,
      13.348312,
      107.343245,
      198,
      ' 8- 3-1998',
      0,
      NULL,
      0.726636,
      0.758889,
      1.823856,
      1,
      0.828425,
      3,
      1,
      0.831794,
      NULL,
      1,
      1.798369,
      0.780104,
      0.017120,
      1.846649,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-20-1982',
      50,
      NULL,
      8,
      6.310098,
      10,
      NULL,
      NULL,
      NULL,
      3,
      21,
      0,
      2.884982,
      132,
      7.518879,
      1,
      50,
      1,
      2.685888,
      NULL,
      ' 9-20-1986',
      99,
      93.460432,
      136,
      0,
      NULL,
      87.574320,
      51,
      91.423217,
      90.475454,
      62.862955,
      81.077364,
      43,
      ' 5-24-2003',
      12.578402,
      7,
      15.198727,
      NULL,
      NULL,
      27.226748,
      5,
      NULL,
      18,
      18.414962,
      ' 9-14-1984',
      1.388076,
      7,
      NULL,
      18,
      0.979839,
      7.075497,
      1.707002,
      NULL,
      0.396042,
      113.727525,
      0,
      NULL,
      NULL,
      28.332326,
      1.715482,
      0.388211,
      0,
      NULL,
      NULL,
      4,
      3.475059,
      5.236845,
      NULL,
      165.563561,
      10.542602,
      ' 9- 6-1977',
      26,
      6.539916,
      ' 5-25-1994',
      44,
      ' 9- 8-1974',
      35,
      NULL,
      1,
      13,
      ' 3- 6-1975',
      14,
      23.462301,
      ' 7-16-1983',
      3.786272,
      2,
      '10- 9-1995',
      NULL,
      13,
      ' 3-12-1995',
      1,
      2,
      NULL,
      NULL,
      7,
      22.747441,
      34,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0);
commit;
end;
/


