set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8128597';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0004',
      '22321041',
      NULL,
      '13313233',
      '02021114',
      NULL,
      NULL,
      NULL,
      '31213322',
      '12430034',
      '01420014',
      NULL,
      NULL,
      '01442104',
      NULL,
      '14023211',
      '42043034',
      '00203403',
      NULL,
      NULL,
      '11201423',
      '12044410',
      '44204131',
      '04440301',
      '43332334',
      NULL,
      '13043143',
      '31012421',
      '20022433',
      '11342240',
      '41322300',
      '11331333',
      '02432233',
      '34003301',
      '22131031',
      '33221320',
      '30303424',
      '14301123',
      '42111310',
      NULL,
      '03134413',
      '00414210',
      '41131431',
      '21120213',
      '12400243',
      '113',
      '44',
      NULL,
      15,
      NULL,
      3.527336,
      29.707851,
      2,
      NULL,
      NULL,
      3.346503,
      ' 5-29-1981',
      ' 2- 9-2002',
      52.997631,
      59,
      NULL,
      14.488857,
      33.742198,
      14,
      44,
      11,
      9,
      NULL,
      26.573029,
      18,
      NULL,
      2.090584,
      4.182292,
      15,
      NULL,
      10.423428,
      23,
      9,
      41,
      0,
      32.308905,
      10.250799,
      1,
      NULL,
      168.408271,
      41.894446,
      131,
      220.300876,
      NULL,
      ' 0-14-1990',
      NULL,
      35.749204,
      NULL,
      6,
      60,
      136,
      ' 2-11-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      46,
      35,
      24.200164,
      17,
      NULL,
      0,
      ' 4-29-1981',
      1.233391,
      NULL,
      98.845070,
      NULL,
      NULL,
      168,
      1.957555,
      0.596062,
      9.895528,
      NULL,
      NULL,
      NULL,
      ' 4- 5-1980',
      101,
      101,
      NULL,
      15.099099,
      121,
      62,
      57,
      34,
      37.836470,
      22,
      74.690083,
      NULL,
      '11-22-1977',
      29.517100,
      NULL,
      16.403165,
      101.984182,
      76,
      184,
      1,
      ' 2- 3-1977',
      3.320057,
      1.171554,
      '11-24-1981',
      3,
      4,
      23,
      13.287141,
      NULL,
      6.334006,
      1,
      19.600471,
      0,
      60,
      0.628564,
      0,
      11,
      9,
      2.313415,
      2.034168,
      4.157409,
      0.789839,
      ' 2- 4-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      200,
      13,
      ' 8-15-1982',
      NULL,
      NULL,
      NULL,
      31,
      ' 2-25-1983',
      42.973205,
      ' 9- 8-1998',
      1,
      10,
      ' 3-26-1995',
      129,
      43,
      ' 2-16-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      18,
      ' 3-11-1979',
      41.236777,
      NULL,
      NULL,
      NULL,
      1,
      15,
      ' 9-18-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


