set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9800326';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '4',
      '4',
      '1',
      '1',
      '4',
      '1',
      NULL,
      '4',
      '3',
      NULL,
      '4',
      '1',
      '3',
      NULL,
      '1',
      '3',
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '3',
      '0',
      '',
      '2',
      NULL,
      '3',
      '3',
      '0',
      '3',
      '4',
      '',
      NULL,
      '4',
      '3',
      '3',
      '4',
      NULL,
      '4',
      '3',
      '1',
      '3',
      '2',
      '4',
      NULL,
      '30244041',
      50.520614,
      61,
      '4233131',
      1,
      0.643654,
      1,
      NULL,
      '331130',
      NULL,
      ' 4- 6-1986',
      ' 3-27-1990',
      100,
      168.000365,
      24.430543,
      19,
      27,
      3.890647,
      80,
      2,
      27.856594,
      13,
      17.593645,
      NULL,
      7.240585,
      8,
      NULL,
      6,
      NULL,
      11.204002,
      9,
      27.667339,
      23.993678,
      18,
      NULL,
      17.432463,
      1,
      37,
      24.523170,
      NULL,
      111.205334,
      205,
      197.578808,
      ' 9- 9-1983',
      42.557922,
      25.578557,
      16.302711,
      18.114535,
      NULL,
      83.584650,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      29,
      1,
      5,
      12.868027,
      13.000548,
      3,
      ' 5-19-2001',
      1.773098,
      NULL,
      211,
      0,
      2.208531,
      70,
      NULL,
      1,
      67,
      NULL,
      NULL,
      NULL,
      ' 6-25-1974',
      2,
      84.671841,
      NULL,
      NULL,
      NULL,
      49.172518,
      NULL,
      NULL,
      75,
      12.091147,
      26.903772,
      86,
      ' 6-16-1986',
      NULL,
      10.791065,
      NULL,
      29,
      23,
      19,
      0,
      '11- 4-1976',
      26.922017,
      25,
      NULL,
      4,
      15.647580,
      20,
      18,
      NULL,
      11,
      0.107282,
      18,
      0.554389,
      7,
      1,
      0,
      13,
      27.173358,
      1.545388,
      1.756439,
      0,
      0.502168,
      '11-21-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      25,
      2,
      ' 8-12-1981',
      NULL,
      NULL,
      NULL,
      7.579650,
      '11- 7-1981',
      1,
      ' 4-16-1994',
      NULL,
      9.862049,
      ' 8- 6-1976',
      68,
      120.665621,
      '11-24-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      15,
      ' 8-10-1989',
      24.712106,
      26.414369,
      NULL,
      ' 4-10-1993',
      NULL,
      2,
      NULL,
      5.506194,
      33.322590,
      9,
      NULL,
      NULL,
      25,
      1,
      53,
      ' 7-23-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


