set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9800326';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '1',
      '2',
      NULL,
      '3',
      '1',
      '0',
      NULL,
      '2',
      NULL,
      '1',
      '4',
      '2',
      '2',
      '2',
      '0',
      '4',
      '1',
      '3',
      '2',
      '4',
      '0',
      '3',
      '1',
      '',
      '1',
      NULL,
      '0',
      '3',
      '1',
      '0',
      '3',
      '',
      '',
      '0',
      '4',
      NULL,
      '4',
      '1',
      '0',
      '4',
      NULL,
      '3',
      '2',
      '1',
      '002',
      NULL,
      NULL,
      6,
      '0232241',
      2,
      10.412164,
      2,
      1,
      '040040',
      4.293324,
      ' 2-14-1987',
      ' 1- 1-1989',
      NULL,
      NULL,
      31.590632,
      15,
      26,
      23,
      55,
      9,
      15,
      6,
      15,
      5,
      6,
      20,
      NULL,
      2,
      NULL,
      13.782038,
      2,
      27.491526,
      77,
      NULL,
      28,
      4,
      NULL,
      1.860534,
      88,
      NULL,
      178,
      117.241455,
      34,
      NULL,
      21,
      9.544537,
      19.876847,
      NULL,
      182.918052,
      197.501182,
      ' 0-20-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      4.564873,
      NULL,
      1,
      ' 5-29-1985',
      1,
      3.404332,
      52.925141,
      0.926371,
      0.183282,
      9,
      1.206133,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-22-1982',
      52.558209,
      95.065771,
      43.765629,
      62,
      NULL,
      81.993526,
      110.694987,
      NULL,
      61.510169,
      36,
      42.913925,
      95.263526,
      ' 1- 8-1996',
      38,
      29,
      8.554555,
      22.865774,
      42.852684,
      149,
      5,
      NULL,
      34,
      35,
      ' 7- 7-1987',
      16,
      22.314826,
      4.602211,
      4.819952,
      NULL,
      4.991499,
      NULL,
      17,
      0.219398,
      47,
      2.723043,
      1,
      6,
      15,
      1,
      3,
      1,
      1.152926,
      '10-13-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      33.860218,
      14,
      NULL,
      NULL,
      NULL,
      NULL,
      16,
      ' 6-20-1988',
      39.963211,
      ' 8- 1-1977',
      13.381651,
      4,
      ' 2-22-1984',
      26.567588,
      36,
      ' 6- 8-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      21.428050,
      '11- 7-1986',
      40.280263,
      34.519708,
      32.616741,
      ' 3- 5-1986',
      1.249356,
      16,
      ' 4-15-1989',
      3.726498,
      17.838458,
      NULL,
      7.994391,
      ' 8- 0-1993',
      NULL,
      1.436735,
      23,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


