set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8133556';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '2',
      NULL,
      '4',
      NULL,
      NULL,
      '0',
      '3',
      '4',
      '4',
      NULL,
      '3',
      '3',
      '3',
      '4',
      '1',
      '0',
      '0',
      '4',
      NULL,
      '1',
      NULL,
      '3',
      '2',
      NULL,
      '3',
      '',
      '3',
      '3',
      '2',
      '3',
      NULL,
      '',
      NULL,
      '1',
      NULL,
      '1',
      '3',
      '1',
      NULL,
      NULL,
      '4',
      '1',
      '0',
      '2',
      '412',
      '12003041',
      53,
      NULL,
      '4014022',
      NULL,
      NULL,
      0,
      NULL,
      '321433',
      0,
      ' 6- 0-2002',
      ' 3-14-1981',
      NULL,
      257.105935,
      3.738631,
      4.359855,
      9.991500,
      11,
      5.809526,
      4.229880,
      12,
      6,
      3,
      9,
      26,
      10,
      7,
      2.419397,
      6,
      NULL,
      14.015161,
      14,
      NULL,
      5.496494,
      NULL,
      8,
      1,
      NULL,
      134,
      NULL,
      144.841506,
      65.803108,
      146,
      ' 0-28-1979',
      12.353244,
      8.117422,
      3,
      18,
      133.203425,
      NULL,
      ' 3-26-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      51.793900,
      30.332907,
      32,
      NULL,
      24,
      NULL,
      NULL,
      0.363819,
      0.680483,
      18.682797,
      NULL,
      NULL,
      7.620840,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      ' 4-14-2001',
      5,
      60,
      93.604524,
      87.543751,
      68,
      77,
      37.825991,
      24.600870,
      37,
      58,
      65,
      44,
      ' 5-14-1982',
      2.376125,
      13.795202,
      2,
      16,
      NULL,
      NULL,
      4.250242,
      ' 3- 7-1975',
      16.911238,
      6,
      ' 8- 2-1974',
      NULL,
      1,
      NULL,
      2.910228,
      8.715578,
      4,
      0.917491,
      NULL,
      1,
      44,
      0,
      1.924044,
      0,
      6,
      1,
      NULL,
      0.936933,
      1,
      ' 6-16-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      23.417605,
      NULL,
      38.299337,
      '11-29-1993',
      1.469658,
      NULL,
      ' 1- 4-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      2,
      ' 6-27-2001',
      NULL,
      9.904372,
      16,
      '11-24-1980',
      0.841349,
      107,
      ' 4-12-1994',
      NULL,
      NULL,
      NULL,
      25.679322,
      ' 0-12-1998',
      45.483880,
      1,
      47.684388,
      ' 3-17-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


