set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9693193';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '10240301',
      NULL,
      NULL,
      '00003130',
      '40442432',
      '42223344',
      '31122302',
      NULL,
      NULL,
      '41121044',
      NULL,
      '22330333',
      NULL,
      '20322244',
      '32001022',
      '04132024',
      '04023413',
      '40231243',
      '40003403',
      NULL,
      '30102043',
      '30141403',
      '32314411',
      '23322222',
      '30242342',
      '32313013',
      '00101412',
      '43441011',
      '03431414',
      NULL,
      '04340112',
      '01432222',
      '24222021',
      '24400101',
      NULL,
      '33303440',
      '31201034',
      '00123003',
      NULL,
      NULL,
      '33020224',
      '43430004',
      '34134413',
      '00331140',
      '201',
      '30',
      NULL,
      24,
      '4140020',
      2.339902,
      NULL,
      NULL,
      NULL,
      NULL,
      4.641292,
      NULL,
      ' 3-22-1989',
      12.365255,
      83.802888,
      35.654652,
      0,
      17,
      4.507298,
      NULL,
      21,
      21,
      11.477513,
      40.262952,
      12.441224,
      31.267202,
      14,
      22.040162,
      NULL,
      3,
      17.542426,
      26,
      21,
      23,
      25.992016,
      35.330402,
      8.233891,
      NULL,
      NULL,
      96.167104,
      10.817285,
      NULL,
      155.167650,
      70.063569,
      ' 4-11-1997',
      12,
      6.706673,
      30,
      17,
      129,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      12.096436,
      22.804065,
      11.335713,
      6.217308,
      2.963111,
      ' 3- 8-1995',
      1.110176,
      NULL,
      171,
      NULL,
      1,
      89.554256,
      NULL,
      NULL,
      27.374361,
      NULL,
      NULL,
      NULL,
      ' 5-24-2003',
      NULL,
      NULL,
      NULL,
      13,
      77.551615,
      77.537471,
      NULL,
      82,
      NULL,
      64,
      NULL,
      NULL,
      ' 4- 4-1994',
      24,
      0,
      NULL,
      69,
      9.344740,
      62,
      NULL,
      ' 9-20-1982',
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      19.431080,
      NULL,
      21,
      NULL,
      NULL,
      NULL,
      NULL,
      113.469796,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10.177495,
      0,
      ' 4- 6-1988',
      NULL,
      NULL,
      NULL,
      24,
      NULL,
      12,
      ' 1- 1-1981',
      20.032541,
      3,
      '11-14-1977',
      66.595252,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      15,
      NULL,
      47,
      NULL,
      28.461907,
      ' 8- 5-1977',
      1.501441,
      126.215990,
      ' 8-17-1990',
      2,
      34.633199,
      8,
      27,
      NULL,
      52.274310,
      1.534200,
      160.937716,
      ' 1-14-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


