set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9857297';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '0',
      '4',
      '4',
      '3',
      '2',
      '3',
      NULL,
      NULL,
      '1',
      '1',
      '0',
      '3',
      '3',
      '1',
      NULL,
      '3',
      '4',
      '2',
      '0',
      '0',
      '4',
      '0',
      '2',
      '',
      '0',
      '',
      '3',
      '0',
      NULL,
      '3',
      '0',
      '',
      '',
      '2',
      NULL,
      '0',
      '2',
      '4',
      '2',
      '0',
      '1',
      '4',
      '3',
      '3',
      '440',
      '00144314',
      73,
      6,
      '3001031',
      3,
      1,
      3,
      NULL,
      '414243',
      NULL,
      ' 0- 7-1985',
      ' 9- 3-1976',
      77,
      77,
      37,
      8.949927,
      NULL,
      NULL,
      74.074035,
      3,
      NULL,
      13,
      24,
      NULL,
      26.982032,
      2.321737,
      8,
      6.663883,
      5,
      NULL,
      NULL,
      7.049610,
      NULL,
      6.978214,
      NULL,
      5,
      0,
      NULL,
      95.637999,
      51,
      14,
      139.498200,
      2,
      ' 5-14-1981',
      26,
      23,
      25,
      9,
      7,
      6,
      ' 1-17-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      22,
      33.342774,
      71,
      2,
      45,
      NULL,
      ' 4-10-1985',
      0,
      0,
      29,
      NULL,
      2,
      15,
      1,
      0,
      13.362841,
      NULL,
      NULL,
      NULL,
      ' 3-11-1982',
      NULL,
      96.422872,
      44,
      71,
      NULL,
      NULL,
      53.638538,
      2,
      24,
      49.952070,
      31.454648,
      69.004915,
      '11-17-2000',
      10,
      12,
      1.798328,
      35.688428,
      NULL,
      13,
      8.498943,
      ' 8-26-1984',
      8,
      3,
      NULL,
      2.852350,
      NULL,
      NULL,
      8,
      7,
      9.308478,
      1.165040,
      10.400848,
      1.643135,
      33.373112,
      2.752564,
      0.605503,
      5,
      NULL,
      0,
      4.107494,
      0,
      1.527923,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      39.563042,
      14,
      ' 2- 8-1994',
      NULL,
      NULL,
      NULL,
      9,
      ' 1-14-1980',
      NULL,
      ' 4- 1-1999',
      1,
      6,
      ' 6-19-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      3.709417,
      '10-29-1990',
      46,
      14,
      0,
      NULL,
      1,
      11.216674,
      ' 3- 1-1979',
      NULL,
      15.209942,
      0.183884,
      33,
      NULL,
      31.125713,
      1.852584,
      56,
      '11-19-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


