set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9857297';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '1',
      NULL,
      '3',
      '0',
      '0',
      NULL,
      '1',
      '3',
      NULL,
      '0',
      NULL,
      NULL,
      '4',
      '4',
      NULL,
      '4',
      '1',
      '2',
      '1',
      NULL,
      NULL,
      NULL,
      '2',
      '',
      '2',
      '',
      '0',
      '3',
      '4',
      '3',
      '0',
      '',
      '',
      '0',
      '3',
      NULL,
      '2',
      '2',
      '1',
      '3',
      '2',
      '4',
      '2',
      NULL,
      '330',
      '14420133',
      70.392811,
      30.831349,
      '1412122',
      NULL,
      21.660776,
      1,
      0,
      '044014',
      NULL,
      ' 9-20-1985',
      ' 2-28-1993',
      82.807921,
      NULL,
      NULL,
      5.934283,
      19,
      NULL,
      26.481714,
      12,
      NULL,
      6.480481,
      23.850014,
      1,
      1,
      10.972851,
      25.578657,
      12.886852,
      10.327691,
      8.128245,
      NULL,
      6.167926,
      7.808123,
      4.080764,
      1.507998,
      4.897417,
      1,
      50,
      NULL,
      61.361799,
      107,
      26,
      85,
      ' 3-15-1978',
      43,
      11,
      26.929441,
      14.798708,
      NULL,
      181.493714,
      ' 8- 8-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      11,
      12.045598,
      6,
      86,
      1,
      ' 5-28-1981',
      NULL,
      0,
      11,
      0,
      1.403529,
      109,
      2,
      0.346054,
      28.561062,
      NULL,
      NULL,
      NULL,
      NULL,
      35,
      6.507849,
      8,
      20.846045,
      39.902892,
      59.486810,
      90.296702,
      NULL,
      NULL,
      88.551205,
      NULL,
      24,
      NULL,
      NULL,
      8,
      16.899526,
      6,
      44.746052,
      19.931387,
      1.728553,
      ' 8-29-1988',
      7.283293,
      NULL,
      ' 9- 8-1990',
      0.929333,
      3.344799,
      10,
      NULL,
      2.235612,
      NULL,
      1.651142,
      14.154734,
      0.480998,
      82.157507,
      0.380922,
      NULL,
      9.272915,
      17.452207,
      0.909873,
      3,
      1,
      1.404140,
      ' 0-24-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      25,
      20.865284,
      ' 2-14-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-13-1980',
      42,
      ' 2-10-1976',
      9,
      3.708406,
      NULL,
      111,
      106,
      ' 3-25-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      12.943200,
      ' 0-28-1981',
      48,
      NULL,
      6,
      ' 3- 3-1978',
      0.698594,
      28,
      ' 7-29-1982',
      5.552729,
      NULL,
      NULL,
      52.830906,
      ' 0- 8-2000',
      31.726159,
      NULL,
      43.842745,
      '10- 3-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


