set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9212254';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2413',
      NULL,
      '44133343',
      '24313213',
      '22411422',
      '24013022',
      '34334013',
      NULL,
      NULL,
      '31141420',
      '42401341',
      '23024410',
      '42333011',
      '04134344',
      '33201443',
      '33101021',
      NULL,
      '23331342',
      NULL,
      '23114042',
      NULL,
      '32133012',
      '10242100',
      '44334043',
      '33004303',
      NULL,
      '23344010',
      '41111243',
      '22400334',
      '32001104',
      '12332421',
      '22124334',
      '41341230',
      '11344000',
      NULL,
      '34302424',
      '44241113',
      NULL,
      '24214112',
      '33241031',
      '31214124',
      '30114134',
      '03324121',
      NULL,
      '40321402',
      NULL,
      '12',
      NULL,
      NULL,
      '3323030',
      1.677760,
      0,
      1,
      NULL,
      '211040',
      2,
      ' 1-26-1976',
      '10- 6-1986',
      54,
      NULL,
      NULL,
      7.446894,
      24,
      18,
      30.284063,
      9,
      3.062358,
      19,
      1.451789,
      11.493483,
      40,
      NULL,
      NULL,
      7,
      31.076883,
      0,
      0,
      8,
      64,
      19,
      63,
      0.869824,
      1,
      68,
      10,
      68.278206,
      83.795682,
      46,
      43,
      ' 3-19-1989',
      14,
      57,
      24,
      30.180956,
      144.396163,
      199.339111,
      ' 9- 5-1996',
      0,
      5,
      5.291981,
      1.452502,
      8.539129,
      2,
      6.260929,
      1.326023,
      0.121837,
      NULL,
      4,
      1.698658,
      NULL,
      0,
      NULL,
      1.445659,
      NULL,
      0.704516,
      0.378339,
      0.874415,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-18-1985',
      NULL,
      9,
      13,
      2.140774,
      6,
      NULL,
      ' 1- 4-2003',
      1,
      1,
      14,
      2.237965,
      0.111509,
      92.301403,
      0.241163,
      1,
      18,
      1.527662,
      0,
      141,
      '11- 1-1996',
      63,
      91.196544,
      5,
      64.543352,
      63,
      15.351540,
      82,
      14.729955,
      79.160790,
      NULL,
      85,
      NULL,
      ' 6-13-2002',
      12.758402,
      10,
      8,
      46,
      25.150851,
      103,
      1,
      ' 2-24-1989',
      11.103117,
      2,
      NULL,
      1.986258,
      6.786842,
      18,
      7,
      23,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      27.249500,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-23-2000',
      0,
      0,
      2,
      ' 7-14-1985',
      74.772455,
      3,
      ' 2-25-1982',
      NULL,
      NULL,
      NULL,
      34,
      NULL,
      7.268854,
      ' 6-21-1975',
      1.876130,
      8.753558,
      ' 8-21-1994',
      24,
      36.733483,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      16.349788,
      ' 1-14-1991',
      8,
      15,
      18.800770,
      '10-24-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.886961);
commit;
end;
/


