set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8801750';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      '43023141',
      '03142300',
      '42244410',
      '30043322',
      '10241331',
      '40303413',
      '01242114',
      '03430412',
      '23440012',
      '02401214',
      NULL,
      '34044333',
      '44432230',
      '12324403',
      '04333233',
      '31034441',
      '32130313',
      '43013342',
      '22402121',
      '03442034',
      '24432001',
      NULL,
      '32334400',
      '10432432',
      '42020130',
      '31344041',
      '03041131',
      '14224344',
      '33241430',
      '40410042',
      '33143134',
      '20242320',
      '44240300',
      '24013322',
      '21110330',
      '00100400',
      '22244140',
      '40020340',
      '34320400',
      '32032141',
      '01414232',
      '34020102',
      '34202410',
      '021',
      '02',
      NULL,
      NULL,
      '2413111',
      NULL,
      1,
      3,
      NULL,
      '324010',
      2,
      NULL,
      ' 8-16-1990',
      27.621934,
      NULL,
      NULL,
      NULL,
      31,
      NULL,
      71,
      5,
      NULL,
      NULL,
      4,
      NULL,
      11,
      1.492825,
      20,
      NULL,
      0.479449,
      NULL,
      47,
      NULL,
      7.124299,
      9,
      72.606731,
      20.810369,
      1,
      67.713272,
      136.108303,
      NULL,
      153.432858,
      186,
      96,
      ' 9-16-1986',
      60,
      NULL,
      NULL,
      14,
      131,
      110,
      NULL,
      2.176370,
      0.487999,
      NULL,
      3.497607,
      0,
      3.158870,
      NULL,
      0,
      1,
      1.099934,
      3.259899,
      0.411794,
      NULL,
      2,
      0.127794,
      1.740524,
      2,
      0,
      NULL,
      2.469100,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-10-1997',
      21.762339,
      15.026778,
      21.987555,
      NULL,
      15,
      7.207963,
      '10-21-1978',
      0,
      0.538956,
      32,
      NULL,
      1.638563,
      132.136268,
      1.904291,
      NULL,
      21.426531,
      NULL,
      NULL,
      NULL,
      '11-16-1979',
      15.760598,
      72,
      98,
      54,
      41,
      33.747037,
      0,
      86.432651,
      73.789203,
      12.352685,
      NULL,
      NULL,
      '11-12-1987',
      NULL,
      12.117494,
      NULL,
      5,
      29.197611,
      80,
      1.023278,
      ' 8-17-1983',
      15,
      NULL,
      ' 2-10-1980',
      NULL,
      6.909575,
      11,
      1.656321,
      9,
      8,
      0,
      9.175505,
      1.355195,
      80.237626,
      0,
      0.402578,
      6.190859,
      12,
      5.131210,
      0,
      1.264239,
      1.871136,
      ' 7- 1-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      173.326052,
      28,
      ' 7-11-1976',
      NULL,
      NULL,
      NULL,
      8,
      ' 9-16-1989',
      32.735910,
      ' 2-18-2001',
      13.176277,
      18.624316,
      ' 6- 3-2003',
      40,
      10.591050,
      ' 8-11-1988',
      0,
      1,
      ' 5-27-1984',
      NULL,
      NULL,
      NULL,
      1,
      3,
      9.178615,
      ' 1-16-1996',
      NULL,
      NULL,
      21.733780,
      ' 0-24-1982',
      0,
      17,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


