set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8801750';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3003',
      NULL,
      '34202331',
      '04212124',
      NULL,
      '41120324',
      '33033324',
      NULL,
      '43342121',
      '01102400',
      '32043403',
      '34403444',
      '01112142',
      '12140023',
      NULL,
      '30041212',
      '34130410',
      '30234314',
      '13032040',
      '30113222',
      '31311314',
      '23100440',
      '42012421',
      NULL,
      '02323242',
      '40224230',
      '00410100',
      '34002300',
      '31314421',
      '14012440',
      '04134030',
      '42411020',
      '04422113',
      NULL,
      '31203100',
      '41413432',
      '00223411',
      '01403031',
      '32330321',
      '14234432',
      '01230232',
      NULL,
      NULL,
      '11130011',
      '14111401',
      '041',
      '02',
      28,
      11.816600,
      '1440141',
      2.560210,
      42.190534,
      0,
      NULL,
      '243043',
      5.413538,
      ' 6- 4-2003',
      NULL,
      NULL,
      115.726397,
      10,
      19.271017,
      18.861154,
      0,
      45,
      22,
      0,
      0.428752,
      26.526418,
      8.023546,
      6,
      10.608747,
      NULL,
      20.638961,
      16.115353,
      6,
      41.208594,
      NULL,
      33,
      25,
      93,
      10,
      1.494949,
      59.208232,
      162,
      19,
      212,
      186.499568,
      69.781771,
      ' 9-23-1998',
      NULL,
      42.946423,
      1.643378,
      2,
      14,
      NULL,
      '10-27-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      28,
      8,
      11,
      14.314963,
      4,
      '10- 8-1981',
      1.083775,
      NULL,
      47,
      0.904944,
      NULL,
      150,
      4,
      1.501144,
      65,
      NULL,
      NULL,
      NULL,
      '10-22-1976',
      1.932559,
      NULL,
      NULL,
      NULL,
      38.516247,
      40,
      65.246805,
      54.048539,
      NULL,
      6.900138,
      33,
      NULL,
      ' 2-14-1979',
      43,
      16.280527,
      NULL,
      19.060136,
      91,
      66,
      1,
      '11-21-2003',
      9.404169,
      10.607588,
      ' 0- 7-2001',
      NULL,
      12,
      10,
      11.348584,
      15.750797,
      11.635253,
      3,
      7.062047,
      1.712075,
      NULL,
      NULL,
      1.047181,
      0,
      10.361807,
      NULL,
      1.275671,
      1.964846,
      0.861540,
      ' 9- 0-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      19.943969,
      0.473333,
      ' 6- 6-1981',
      NULL,
      NULL,
      NULL,
      28,
      NULL,
      19.766512,
      ' 5-29-1995',
      2,
      1,
      '10-17-1985',
      NULL,
      92.778020,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      14,
      ' 6- 6-2000',
      25,
      15.757723,
      9.475918,
      '10-13-1985',
      1,
      27,
      ' 6-16-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


