set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9501630';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1223',
      '10041430',
      '00002242',
      '12331033',
      '41033000',
      '40330331',
      '20212321',
      '20403144',
      '24222021',
      NULL,
      '13034310',
      '12320002',
      NULL,
      '41433123',
      '24301024',
      '22234002',
      '04333442',
      '02423124',
      '44231020',
      NULL,
      '43304232',
      '44112341',
      '20103010',
      NULL,
      '22011104',
      '02033241',
      '23203311',
      '20031331',
      '23032223',
      '20214422',
      '12413431',
      NULL,
      '40014220',
      '32000133',
      '03000201',
      '10223231',
      '33241030',
      NULL,
      '33222400',
      '34111131',
      NULL,
      '41304222',
      '12333003',
      '40310012',
      '42410403',
      '413',
      '03',
      NULL,
      NULL,
      '4330320',
      NULL,
      1.249140,
      2,
      NULL,
      '202113',
      0.973070,
      ' 3-24-1977',
      '11-24-1996',
      4,
      NULL,
      NULL,
      5,
      4,
      14.962703,
      NULL,
      6.236841,
      3.838921,
      16,
      13,
      12,
      1,
      NULL,
      9.927427,
      10.047262,
      8.800024,
      12,
      31,
      1,
      NULL,
      13.787970,
      28.096446,
      18,
      0.739310,
      29.674890,
      128.904127,
      NULL,
      144,
      NULL,
      54.066510,
      ' 1-29-1980',
      15.238967,
      NULL,
      23,
      12,
      19.902860,
      161,
      ' 7- 2-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      39.414229,
      8,
      11,
      NULL,
      NULL,
      0,
      ' 9-29-1985',
      2,
      3.540935,
      181,
      0,
      2.406578,
      97.830379,
      0,
      0,
      60.841905,
      NULL,
      NULL,
      NULL,
      ' 2-14-1989',
      NULL,
      NULL,
      77.032346,
      102.342942,
      16.163090,
      21,
      23.870736,
      57,
      33,
      51,
      49,
      22,
      ' 7-24-1976',
      23.708427,
      12,
      21.829448,
      NULL,
      44.200732,
      77,
      4,
      ' 6-17-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      98.481884,
      12,
      NULL,
      NULL,
      NULL,
      NULL,
      20,
      ' 4- 3-2003',
      7,
      ' 7-15-1995',
      2.141705,
      10.047692,
      NULL,
      106,
      18,
      '11- 2-1989',
      NULL,
      NULL,
      ' 5-10-1979',
      NULL,
      NULL,
      NULL,
      1,
      0,
      9.782522,
      ' 2-21-1989',
      NULL,
      1,
      6.001965,
      ' 6-12-1981',
      1.047267,
      118,
      ' 7-22-1992',
      14.855206,
      74.885640,
      2,
      28,
      '11- 1-1985',
      60,
      NULL,
      230,
      ' 8-12-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


