set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9501630';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0110',
      '43213402',
      '11231440',
      '30013023',
      '23010333',
      '31100314',
      '04012120',
      NULL,
      '04403343',
      '13032011',
      NULL,
      '14041020',
      '44440130',
      '33032230',
      '23230433',
      NULL,
      '22234002',
      '42230400',
      '04020422',
      '43211101',
      '30213411',
      NULL,
      '24301022',
      NULL,
      NULL,
      '11220202',
      '32304341',
      '13242101',
      NULL,
      '00431424',
      '34412412',
      '32422304',
      NULL,
      '32001324',
      '41320131',
      '30004232',
      '23230424',
      '24314320',
      '22213432',
      NULL,
      '32400100',
      '04122433',
      '42444024',
      '34324132',
      '22223242',
      '430',
      '43',
      35,
      9,
      '2231143',
      2,
      NULL,
      NULL,
      NULL,
      '141240',
      0.620490,
      NULL,
      NULL,
      85.629468,
      23.568560,
      NULL,
      2.379593,
      13,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.091214,
      1.097017,
      27,
      14.719187,
      2.779324,
      17.141139,
      0,
      5,
      36.417658,
      3.610360,
      3,
      NULL,
      20.487592,
      8,
      1,
      60.346466,
      89.548413,
      55,
      141.240282,
      84.634950,
      NULL,
      ' 2- 7-1983',
      NULL,
      5,
      27.357974,
      9,
      55.470694,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19,
      24,
      1.422842,
      9,
      4.502613,
      7,
      ' 5-21-1994',
      1,
      0,
      39,
      1.776709,
      3,
      100,
      0.621469,
      3.397558,
      49,
      NULL,
      NULL,
      NULL,
      ' 6- 3-1988',
      96.523097,
      NULL,
      42.545106,
      114,
      38.836783,
      29,
      70,
      11,
      NULL,
      NULL,
      NULL,
      7,
      ' 1- 3-1998',
      16.406203,
      13,
      1.619558,
      NULL,
      44.507368,
      5.378564,
      2.200207,
      ' 9- 3-1998',
      4.792917,
      NULL,
      ' 9-12-1981',
      10,
      5,
      13,
      10,
      17.913089,
      6,
      0,
      NULL,
      1.625088,
      91.865043,
      0.738987,
      0,
      8,
      10.383618,
      NULL,
      0,
      0.274593,
      1.559959,
      ' 6-10-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      39,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      43.782810,
      '10-19-1985',
      34.617133,
      '10-19-1987',
      9,
      12,
      ' 1- 5-1995',
      14,
      41,
      '10-12-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      4,
      ' 6-13-1991',
      25.340952,
      7,
      10.291957,
      '10-17-2000',
      3.604168,
      51,
      NULL,
      7.310878,
      128.687398,
      7,
      30.677271,
      '11-21-1987',
      30,
      NULL,
      NULL,
      '11-10-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


