set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9501630';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '2',
      '0',
      NULL,
      '4',
      '2',
      '3',
      NULL,
      NULL,
      '3',
      '4',
      '4',
      '3',
      '3',
      '3',
      '2',
      NULL,
      '2',
      '0',
      '2',
      '0',
      '2',
      '1',
      '2',
      '',
      '1',
      NULL,
      '4',
      '4',
      NULL,
      NULL,
      '1',
      '',
      '',
      NULL,
      '1',
      '0',
      '0',
      '0',
      '1',
      '1',
      '0',
      '0',
      '0',
      '1',
      '433',
      NULL,
      11.272840,
      NULL,
      '2114114',
      0.005305,
      50,
      2,
      NULL,
      '221301',
      0.954263,
      ' 5-29-1986',
      ' 6-13-1975',
      57.713218,
      240.831415,
      11,
      3,
      31,
      2,
      3,
      2.168479,
      13.416718,
      4.500156,
      28,
      NULL,
      18,
      8,
      5.573987,
      17,
      19.792075,
      2.873955,
      11.931690,
      3,
      26.214275,
      NULL,
      53,
      11.666418,
      0.038186,
      4.599617,
      11.799895,
      34.658900,
      131,
      8.195498,
      146.282423,
      '10- 4-1998',
      38,
      4,
      18,
      20.546194,
      25,
      NULL,
      ' 9-11-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      30,
      25.810204,
      NULL,
      NULL,
      30,
      4,
      NULL,
      1.531383,
      NULL,
      3,
      1.765001,
      1.245003,
      118,
      1,
      NULL,
      2.267394,
      NULL,
      NULL,
      NULL,
      ' 5-11-1990',
      NULL,
      69,
      NULL,
      62,
      72.778674,
      1.989030,
      71,
      73,
      NULL,
      52.475952,
      NULL,
      71.680926,
      ' 0- 6-1995',
      14.607646,
      11.689116,
      4,
      NULL,
      73,
      140,
      NULL,
      ' 6- 4-1999',
      31,
      NULL,
      ' 8-17-1992',
      2,
      11,
      17.858740,
      9.408994,
      10.838011,
      6,
      1.042860,
      1,
      0,
      18,
      2,
      NULL,
      14,
      2.378378,
      1,
      3.270434,
      1,
      NULL,
      '10-12-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      80,
      18,
      ' 6-21-1977',
      NULL,
      NULL,
      NULL,
      35.852978,
      ' 3-13-1984',
      NULL,
      '10- 2-1990',
      NULL,
      2,
      ' 5-14-1977',
      22,
      1.037328,
      ' 4-23-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      ' 4-19-1985',
      37,
      31.843770,
      3,
      ' 5-22-1996',
      1,
      42,
      NULL,
      11.516213,
      33,
      NULL,
      12,
      ' 8-18-1978',
      4.242976,
      0.392418,
      36.692039,
      ' 9- 7-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


