set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9501630';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '4',
      NULL,
      '2',
      '2',
      '1',
      '0',
      '0',
      NULL,
      '1',
      NULL,
      '1',
      '0',
      NULL,
      '1',
      '1',
      '4',
      '1',
      '4',
      NULL,
      '2',
      '4',
      '1',
      '1',
      NULL,
      NULL,
      '',
      '2',
      '2',
      '3',
      '4',
      '1',
      '',
      NULL,
      NULL,
      '4',
      '0',
      '3',
      '0',
      '4',
      '1',
      NULL,
      '0',
      '0',
      '1',
      '100',
      '04100413',
      13.156171,
      57.894918,
      '3240041',
      1,
      3.376471,
      1,
      0,
      NULL,
      2.424357,
      ' 9- 4-1984',
      NULL,
      9,
      NULL,
      9.493337,
      11.352282,
      NULL,
      8,
      5,
      5,
      10.946892,
      10.393064,
      17.882294,
      NULL,
      29,
      NULL,
      NULL,
      16,
      8,
      NULL,
      NULL,
      0.976030,
      0,
      8,
      8.735447,
      12,
      0.361170,
      32,
      158,
      63.825244,
      NULL,
      102.920260,
      27,
      NULL,
      32.827832,
      13.074637,
      17.959800,
      18,
      105,
      84,
      ' 2-27-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      57,
      4,
      11.606698,
      14.016155,
      NULL,
      3.280978,
      '10- 2-1984',
      1,
      NULL,
      NULL,
      0,
      NULL,
      31.999524,
      NULL,
      NULL,
      41.018094,
      NULL,
      NULL,
      NULL,
      '11- 6-1974',
      96.977139,
      22,
      NULL,
      31.149511,
      40,
      14.511656,
      NULL,
      NULL,
      NULL,
      11.460545,
      9.841715,
      NULL,
      ' 7-24-1983',
      2,
      29.310316,
      2.848429,
      1.212591,
      62,
      7,
      1,
      NULL,
      14,
      0.235139,
      ' 7- 1-1998',
      10,
      7.475604,
      15,
      NULL,
      19,
      5,
      NULL,
      NULL,
      1,
      50.137681,
      9.809012,
      0.807567,
      3,
      29,
      3,
      NULL,
      0.759920,
      1.800101,
      ' 3- 8-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      115,
      4,
      '11- 5-1998',
      NULL,
      NULL,
      NULL,
      32,
      '10-21-1991',
      11.071987,
      ' 2-26-2003',
      3,
      5,
      ' 9-20-1976',
      140.553702,
      85,
      ' 4-12-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      17,
      ' 2-11-1997',
      NULL,
      21.294445,
      NULL,
      ' 7-14-1990',
      NULL,
      135,
      ' 8- 1-1998',
      2.460623,
      0,
      2.940408,
      51.430689,
      ' 2- 0-2003',
      3,
      0.359369,
      122,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


