set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7624047';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2403',
      '03112413',
      '30433343',
      '00223121',
      '11030244',
      '42433114',
      '10140133',
      '01041301',
      '32220423',
      '32333220',
      '33021003',
      '44443031',
      '43300013',
      NULL,
      '21112123',
      '10304102',
      '30230433',
      NULL,
      '00433020',
      '41340330',
      '34432122',
      '02142303',
      NULL,
      '20134443',
      '12203101',
      NULL,
      '30240430',
      '10403004',
      '23232113',
      NULL,
      '41030324',
      '20131303',
      '34200030',
      '22221411',
      '31131040',
      NULL,
      '03130444',
      '34013111',
      NULL,
      '14024323',
      '04434323',
      NULL,
      '02322133',
      '12112143',
      '13303310',
      '042',
      '41',
      NULL,
      NULL,
      '1320001',
      NULL,
      0.332712,
      1,
      NULL,
      '104024',
      2,
      ' 7-24-1980',
      ' 2- 8-2003',
      NULL,
      NULL,
      20.992786,
      9,
      NULL,
      11.042010,
      35.263767,
      16.677396,
      5.933546,
      20,
      24.851071,
      1.547842,
      5.741826,
      NULL,
      18.492988,
      18,
      16,
      6,
      27,
      0,
      NULL,
      10.996712,
      39.197014,
      7,
      0,
      9,
      50,
      64.169833,
      113.103205,
      NULL,
      171,
      ' 1-18-1985',
      1.251477,
      NULL,
      NULL,
      29.341328,
      165,
      6.218150,
      ' 3-26-1994',
      0.763021,
      3.377336,
      0,
      NULL,
      4,
      1.076226,
      1,
      0,
      NULL,
      0.674262,
      NULL,
      0.360108,
      0.749718,
      NULL,
      1.043333,
      1.396943,
      0,
      0.596747,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-26-1977',
      12,
      25,
      24.957603,
      5.902644,
      19,
      1,
      ' 1-24-1988',
      1,
      0.433582,
      112,
      0.224398,
      3.050722,
      118,
      1,
      NULL,
      27.007841,
      NULL,
      NULL,
      NULL,
      ' 6- 5-1985',
      98,
      54,
      NULL,
      73.779430,
      42.033757,
      NULL,
      69,
      46.005878,
      NULL,
      39.055223,
      5.248900,
      NULL,
      ' 3-18-1988',
      4.112869,
      3,
      NULL,
      44,
      39.765600,
      11,
      3.634243,
      NULL,
      0,
      17,
      '10-27-1993',
      11.509165,
      NULL,
      12,
      7.837510,
      NULL,
      0.526909,
      NULL,
      13.903219,
      NULL,
      48.702098,
      1.720200,
      1,
      6,
      NULL,
      NULL,
      14,
      15.606420,
      6.774125,
      ' 1-12-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      ' 4- 8-1999',
      NULL,
      NULL,
      NULL,
      12.903067,
      ' 8- 3-1991',
      4,
      ' 6-10-1993',
      6,
      NULL,
      '10-14-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      9.430623,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      ' 1- 6-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      86.565745,
      '11-23-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


