set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9727338';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4203',
      NULL,
      '14130130',
      '13243134',
      '31143211',
      '14020101',
      '11404014',
      '22014331',
      NULL,
      '42000412',
      '32012410',
      NULL,
      '02041032',
      '23321321',
      '20004023',
      NULL,
      '20143100',
      '30303124',
      '02310110',
      '00214114',
      '30334330',
      '20332030',
      '10400333',
      '02034312',
      '00131313',
      '22032213',
      NULL,
      '41400342',
      '34434140',
      '24143003',
      '02102443',
      '01440002',
      '11142112',
      '10404213',
      NULL,
      '44022203',
      '00111310',
      '43022144',
      '31411044',
      '41343343',
      '24331223',
      '04320340',
      '00032030',
      '10304042',
      '02000002',
      '234',
      '33',
      12,
      43.035381,
      '1242413',
      2,
      0.239874,
      1,
      NULL,
      '211011',
      NULL,
      ' 8-26-1989',
      ' 7- 3-1974',
      23.764320,
      8.986366,
      NULL,
      13,
      14,
      4.284447,
      101,
      23.740855,
      14,
      15,
      47,
      NULL,
      NULL,
      19,
      NULL,
      15,
      NULL,
      NULL,
      78,
      NULL,
      14.403159,
      20,
      NULL,
      18,
      NULL,
      73.191753,
      10.183241,
      41,
      176,
      107,
      219.476655,
      NULL,
      33,
      25,
      30,
      24.423689,
      NULL,
      210,
      ' 6-29-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      57,
      5,
      1,
      NULL,
      15.519143,
      3.025247,
      NULL,
      NULL,
      NULL,
      91,
      1.402480,
      3.899583,
      23,
      0.545046,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      36.532696,
      47,
      50.455540,
      60,
      43,
      72.267766,
      80,
      59.504466,
      31,
      50,
      NULL,
      51,
      ' 7-16-1999',
      14.122553,
      13.428693,
      13.728838,
      2.370685,
      65,
      98.713643,
      3,
      ' 9- 2-1977',
      NULL,
      0,
      ' 7- 2-1986',
      NULL,
      4,
      NULL,
      2,
      12,
      NULL,
      1,
      8,
      0.002642,
      90.342553,
      1.756406,
      3,
      5.259729,
      30,
      NULL,
      0.165409,
      0.283272,
      0,
      ' 0-12-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      14,
      5,
      ' 8-29-1987',
      NULL,
      NULL,
      NULL,
      39.795890,
      NULL,
      16.362303,
      ' 9-20-1979',
      13.239450,
      17.452198,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      10.875611,
      ' 2-28-2003',
      NULL,
      5.196267,
      27,
      ' 7- 6-1998',
      2.436144,
      68,
      ' 7-24-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


