set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8229218';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2200',
      '00010133',
      NULL,
      NULL,
      NULL,
      '03000132',
      '12423312',
      '24400442',
      '33211211',
      '33040004',
      '32112034',
      '00133112',
      '31432204',
      NULL,
      '20303433',
      '22030333',
      '34300132',
      '34241402',
      '11422301',
      '02414241',
      NULL,
      '20341130',
      '04320122',
      NULL,
      '33233234',
      '14331020',
      '20122414',
      '10413313',
      '32214434',
      NULL,
      NULL,
      '30231443',
      '22004230',
      NULL,
      '31002031',
      '23244321',
      '22203134',
      '01002002',
      '42444303',
      '41133341',
      '20324130',
      '04024010',
      '40112022',
      '44230210',
      '33422210',
      '',
      NULL,
      NULL,
      NULL,
      '4014321',
      1.309538,
      NULL,
      2,
      NULL,
      '100421',
      1,
      NULL,
      ' 2- 0-1979',
      12.278447,
      NULL,
      NULL,
      3,
      15,
      10,
      80,
      7,
      0.139749,
      18.650387,
      38,
      6,
      4,
      10.227236,
      29.372812,
      7.060120,
      1.304531,
      3,
      40,
      1.696154,
      19.387536,
      18,
      45,
      14.800958,
      NULL,
      109.910728,
      85.607587,
      62,
      10.195860,
      134,
      169,
      ' 8-12-1991',
      12.055697,
      23.030798,
      11,
      14.813065,
      174.815604,
      204,
      ' 6- 4-1995',
      NULL,
      0,
      2.353940,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.748466,
      0,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-18-2000',
      35.066242,
      85.066618,
      9,
      NULL,
      17,
      NULL,
      1,
      19.797057,
      NULL,
      29.941932,
      35.066951,
      83,
      NULL,
      10,
      22,
      5.520155,
      39.098219,
      60.255245,
      181.680829,
      12.570693,
      NULL,
      3.829061,
      25,
      ' 3-12-1987',
      10,
      NULL,
      5,
      12,
      6.019093,
      1.061061,
      NULL,
      NULL,
      NULL,
      29.934896,
      1.760633,
      7,
      4.326697,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-12-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13,
      20,
      6,
      ' 5-10-1980',
      1,
      35,
      ' 4- 8-1980',
      NULL,
      3,
      NULL,
      37.153031,
      ' 7-24-1984',
      NULL,
      1.170222,
      145.022430,
      ' 0- 7-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      61.170476,
      42,
      148.698888,
      39,
      22,
      7,
      19.203597,
      NULL,
      85,
      0,
      1,
      72.209327,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      74.307034,
      NULL,
      1,
      101,
      86,
      24,
      83.970637,
      1,
      63,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      51.550504,
      55.395976,
      NULL,
      16,
      52.478993,
      NULL,
      1,
      2,
      NULL,
      0.928152,
      5,
      0.253446,
      5,
      NULL,
      61,
      1.657005,
      72,
      0,
      NULL,
      93,
      1.813570,
      NULL,
      1,
      49,
      NULL,
      20,
      73,
      5,
      10.458777,
      NULL,
      0.321374,
      1.581074,
      0,
      NULL,
      0.480464,
      NULL,
      NULL,
      ' 4-25-1992',
      ' 2-27-1981',
      ' 9-11-1982',
      ' 8-18-1991',
      NULL,
      ' 5- 8-2001',
      NULL);
commit;
end;
/


