set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8229218';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0404',
      '03022111',
      NULL,
      '31412424',
      '20234120',
      '31442314',
      '43003213',
      '14331433',
      '33122010',
      '03000423',
      '13120300',
      '13000324',
      '32141034',
      '10131132',
      NULL,
      '40213112',
      '42303110',
      '21222223',
      '13234443',
      '40001340',
      '44220403',
      '43400101',
      '24112000',
      '43024144',
      '02421330',
      '42400120',
      NULL,
      '11412242',
      '13420412',
      '30231040',
      NULL,
      '44223112',
      NULL,
      '10313132',
      '41324211',
      '34144141',
      '02342000',
      '43220143',
      '32041432',
      '03311212',
      '44422331',
      '33003400',
      NULL,
      '31424044',
      '02324102',
      '442',
      NULL,
      NULL,
      NULL,
      '3420122',
      2.335797,
      23,
      2,
      NULL,
      '204102',
      NULL,
      ' 7-29-1992',
      ' 5-11-1997',
      56,
      NULL,
      24,
      2.005886,
      6.811316,
      14,
      25.296246,
      3,
      NULL,
      8.120266,
      16,
      17.467490,
      5.624433,
      6,
      6.256213,
      1,
      11.697289,
      21.239880,
      15.497343,
      10.716608,
      3,
      NULL,
      3,
      11.866405,
      0,
      71.871981,
      85,
      80,
      NULL,
      165,
      149,
      NULL,
      7,
      47.717885,
      25.371616,
      15,
      160.862712,
      184,
      ' 2-15-1976',
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      1.907925,
      NULL,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      0,
      1.189346,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 9-1976',
      NULL,
      NULL,
      NULL,
      9.289151,
      9.848707,
      2.106832,
      '11- 9-1997',
      1,
      1.872960,
      145.598387,
      0.568678,
      1,
      126,
      NULL,
      0.613126,
      3.750654,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      70.838582,
      63.041195,
      NULL,
      102,
      NULL,
      51,
      66.640072,
      21.338249,
      93.122498,
      26,
      49.544469,
      ' 9-20-1977',
      21.281738,
      27,
      NULL,
      8,
      93,
      132,
      12.476067,
      ' 5-26-1984',
      6.385993,
      18.690464,
      ' 1- 3-1976',
      4.687355,
      12,
      3,
      0.656018,
      NULL,
      2.994718,
      0,
      9.156524,
      1,
      NULL,
      1.288618,
      8,
      NULL,
      4,
      NULL,
      2,
      0.690397,
      1,
      ' 8-13-1996',
      0.325068,
      2.686370,
      3.268611,
      ' 9- 6-1984',
      NULL,
      49.602442,
      NULL,
      NULL,
      NULL,
      NULL,
      34,
      ' 0-20-1979',
      40,
      ' 3- 4-1995',
      1,
      0.119385,
      ' 4-25-1981',
      68,
      20,
      ' 3-21-1997',
      7,
      8,
      '11-25-1994',
      1,
      NULL,
      ' 4-18-1996',
      1,
      3,
      NULL,
      ' 8- 6-1983',
      31,
      NULL,
      29.909157,
      ' 9-18-1997',
      1.984222,
      45,
      NULL,
      7,
      4,
      2,
      2.368561,
      ' 1-20-1988',
      26.288118,
      0,
      86.035622,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


