set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8229218';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '3',
      '2',
      '2',
      '3',
      '0',
      NULL,
      '2',
      '3',
      '4',
      '3',
      '4',
      '0',
      '0',
      '4',
      '2',
      '2',
      '2',
      '1',
      '0',
      NULL,
      '1',
      '0',
      '2',
      '',
      '4',
      '',
      '3',
      '0',
      NULL,
      '1',
      '4',
      NULL,
      '',
      '0',
      NULL,
      '2',
      NULL,
      '1',
      '4',
      '4',
      '4',
      '3',
      '4',
      '0',
      '101',
      '12223043',
      36,
      NULL,
      '0114041',
      NULL,
      39.461703,
      1,
      NULL,
      '331244',
      3,
      ' 7-26-1983',
      ' 5-25-2003',
      101,
      65,
      17,
      13,
      11.339602,
      8,
      NULL,
      10.348828,
      2.189381,
      18.427258,
      10,
      3,
      NULL,
      21,
      30.884182,
      12,
      5.351578,
      6,
      36.757489,
      10,
      63,
      19,
      88,
      13.123289,
      1,
      89,
      62.486919,
      3.443671,
      170,
      25,
      172.378011,
      NULL,
      6,
      33,
      26.117617,
      0,
      128,
      32,
      ' 0-25-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      18,
      44.887087,
      1.103205,
      38.645720,
      1.284620,
      '11- 0-1990',
      1.367689,
      0,
      NULL,
      0,
      0.340874,
      6.957610,
      1.641152,
      0,
      59,
      NULL,
      NULL,
      NULL,
      NULL,
      109.507733,
      106,
      110,
      17,
      11,
      97.113106,
      92.147303,
      NULL,
      NULL,
      7,
      NULL,
      21.982374,
      ' 5-27-2003',
      22.155851,
      NULL,
      NULL,
      NULL,
      5.551842,
      46.919240,
      NULL,
      ' 5-24-1981',
      5,
      7,
      ' 1-18-1985',
      10,
      NULL,
      5.109274,
      5.687070,
      9,
      NULL,
      0,
      NULL,
      1.358431,
      70.539457,
      0.748353,
      NULL,
      4.462065,
      18,
      1,
      0.189640,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-20-1992',
      NULL,
      NULL,
      NULL,
      33,
      ' 4-14-1986',
      7,
      ' 8- 2-1977',
      4,
      6,
      NULL,
      17.574673,
      74.171975,
      ' 8-29-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      ' 9- 8-1996',
      NULL,
      3.703667,
      NULL,
      NULL,
      1.662839,
      57.920940,
      ' 2-14-1983',
      13,
      NULL,
      NULL,
      3.473167,
      '10-10-1996',
      3,
      NULL,
      80.697671,
      ' 9- 6-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


