set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9620900';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '44100123',
      '24121210',
      '34203401',
      '31132432',
      NULL,
      '32302431',
      '34331414',
      '23112122',
      '43241000',
      '02033021',
      '02231331',
      NULL,
      '44000304',
      NULL,
      '03423432',
      '40210103',
      NULL,
      NULL,
      '12112220',
      NULL,
      NULL,
      '44113034',
      '10010344',
      '40340400',
      '04433204',
      '23041342',
      '01022343',
      NULL,
      '20223133',
      '20012321',
      '13210421',
      '21342412',
      '41224323',
      '12210342',
      '34240131',
      '43021124',
      '40312431',
      NULL,
      NULL,
      '30330434',
      '20244223',
      '31341041',
      '01240220',
      '02003033',
      '222',
      '31',
      41,
      10,
      '4301044',
      0.883262,
      1,
      2,
      NULL,
      '110101',
      2.772785,
      ' 5-24-1997',
      ' 5- 0-1992',
      NULL,
      32.021250,
      NULL,
      8,
      3.983841,
      6,
      78,
      9.885267,
      21.610489,
      24.393558,
      45.730407,
      0.772332,
      26.830201,
      NULL,
      25.800974,
      17.631663,
      30.928394,
      20,
      48.123898,
      5.694488,
      20,
      3,
      13.218618,
      NULL,
      0,
      NULL,
      223.289218,
      92.868274,
      88,
      NULL,
      41,
      ' 6-14-2000',
      44,
      8,
      NULL,
      34,
      80,
      91.083755,
      ' 1- 3-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      91,
      4.373628,
      1.628580,
      NULL,
      4.787361,
      3,
      ' 3- 4-1999',
      1.016797,
      2.683778,
      6.281001,
      0.419869,
      0.551253,
      22.006624,
      2,
      0.736446,
      55,
      NULL,
      NULL,
      NULL,
      ' 0- 6-2002',
      5,
      93.560914,
      99.969273,
      10,
      82,
      90,
      22,
      16,
      NULL,
      23.815986,
      57,
      23.406535,
      ' 2-20-1992',
      11.265806,
      12.088263,
      8,
      NULL,
      13,
      52,
      NULL,
      ' 1-20-1996',
      21,
      NULL,
      '10- 6-1995',
      6.756985,
      20,
      26.936125,
      4,
      15.730621,
      6,
      1.683483,
      22,
      0.366868,
      100,
      0,
      3.826169,
      6,
      12,
      1,
      1,
      1,
      1.232539,
      ' 4-28-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-11-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.470661,
      '11- 1-1989',
      74,
      45.048719,
      ' 4-17-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      13,
      ' 0- 1-1986',
      73.320723,
      NULL,
      46,
      NULL,
      1.094448,
      75.516256,
      ' 6-26-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


