set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9129845';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0012',
      '33200002',
      '12232034',
      '44141321',
      '22404230',
      '44231041',
      NULL,
      '24123110',
      NULL,
      '22331434',
      '21204212',
      '14404434',
      '10122324',
      '42101242',
      '20330022',
      '14411030',
      '32303421',
      '34002341',
      '00301434',
      '24204033',
      '01043414',
      '44242112',
      '04003322',
      '44342213',
      '30414242',
      '21111213',
      '31133104',
      '22013002',
      '22400201',
      '10321331',
      '41300233',
      '12320331',
      NULL,
      '24013302',
      '01320001',
      '22311124',
      '01332141',
      NULL,
      '21103131',
      NULL,
      NULL,
      NULL,
      '20001223',
      '24131344',
      '42244340',
      '402',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.238084,
      NULL,
      NULL,
      NULL,
      5,
      ' 2-26-1979',
      ' 1-23-1988',
      25.728446,
      NULL,
      25,
      16,
      8.139537,
      11,
      NULL,
      21.135301,
      25,
      3.042730,
      14,
      9,
      NULL,
      20,
      4.815174,
      10.282674,
      NULL,
      NULL,
      34,
      NULL,
      48.658680,
      4,
      54,
      21.776890,
      1.849497,
      NULL,
      55.751115,
      NULL,
      178,
      75,
      NULL,
      ' 7-28-1978',
      24,
      70.927132,
      2,
      33,
      35,
      0.776702,
      ' 5-27-1979',
      NULL,
      1.168057,
      1,
      1.338780,
      1.027816,
      0,
      0,
      0.690193,
      1.869621,
      1,
      NULL,
      1.767301,
      1.574967,
      0.189372,
      0.379178,
      1,
      0.113870,
      1.071738,
      0.492464,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-25-1991',
      18.844864,
      NULL,
      NULL,
      32,
      4,
      1,
      ' 4-11-1991',
      NULL,
      NULL,
      35.406175,
      1.285783,
      1.672935,
      54,
      1,
      NULL,
      101,
      1,
      1.186909,
      63,
      ' 9-14-1985',
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      NULL,
      62,
      NULL,
      54,
      17,
      84.756565,
      33.186969,
      '11- 4-1974',
      3,
      NULL,
      6,
      65,
      51.825449,
      93,
      9.060626,
      ' 8-29-1989',
      25.019397,
      3.152348,
      ' 0-17-1992',
      3.283476,
      19.973210,
      20,
      1,
      22,
      4.624099,
      0,
      18,
      0.717241,
      NULL,
      6,
      0.256312,
      11,
      18,
      1.571337,
      NULL,
      0.106654,
      0.353211,
      NULL,
      6.299933,
      1,
      NULL,
      ' 0- 4-1999',
      NULL,
      NULL,
      ' 3- 3-1977',
      27.532530,
      7.603710,
      ' 7- 7-1998',
      35,
      ' 0-12-1979',
      NULL,
      ' 1-21-1998',
      19.196196,
      3,
      ' 0-27-1977',
      76,
      NULL,
      ' 3- 1-1982',
      0.587238,
      3.126834,
      ' 4-14-2002',
      14.759070,
      15.040007,
      NULL,
      NULL,
      1,
      21,
      ' 7-20-1985',
      69,
      NULL,
      49.450207,
      ' 9- 5-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15);
commit;
end;
/


