set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908830';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3324',
      '00400240',
      NULL,
      '23230410',
      '31434102',
      '14134443',
      '13040032',
      '21134013',
      '21110234',
      '43203410',
      '33334043',
      '01300104',
      '14003242',
      '22430103',
      '14143322',
      '14012020',
      '22220321',
      '21231244',
      '42423132',
      '13424010',
      '23220401',
      '11242303',
      '12412323',
      '32403043',
      '00331401',
      '02343343',
      '44324332',
      '24223241',
      '01001443',
      '32344341',
      '11112104',
      '32303032',
      '31002004',
      '10120131',
      '24220241',
      NULL,
      '30011204',
      NULL,
      '03230334',
      '12221341',
      NULL,
      NULL,
      NULL,
      '14441023',
      '20110223',
      NULL,
      '',
      NULL,
      NULL,
      '3211021',
      1,
      NULL,
      2,
      NULL,
      '314214',
      1,
      ' 4-14-1984',
      NULL,
      29,
      NULL,
      NULL,
      15,
      6.486561,
      9.893868,
      NULL,
      7.295070,
      1.942752,
      NULL,
      33,
      0,
      27.886821,
      16.167183,
      27.461617,
      17.796217,
      17.001657,
      11,
      4.547527,
      NULL,
      NULL,
      3,
      70,
      11.511652,
      NULL,
      14.564882,
      NULL,
      31,
      86,
      69,
      NULL,
      ' 2- 2-1991',
      5.840090,
      29.206590,
      30.540044,
      12.767765,
      4.085686,
      72.156311,
      '10-25-1990',
      3,
      2,
      NULL,
      2.718781,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      4.158335,
      0.652147,
      0.001099,
      2.407160,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-23-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-24-1977',
      15.485070,
      NULL,
      NULL,
      53.262851,
      94.163676,
      NULL,
      67.844634,
      100,
      NULL,
      110.138610,
      NULL,
      NULL,
      NULL,
      8.048799,
      11,
      11,
      22,
      62.053345,
      106,
      9.773601,
      ' 0-20-1998',
      NULL,
      NULL,
      ' 4-14-1986',
      NULL,
      9,
      0,
      1.128836,
      14,
      3,
      NULL,
      1.092368,
      NULL,
      23.669930,
      1.675124,
      1.084934,
      6.958813,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      48.130721,
      8.268451,
      0,
      ' 2-19-1995',
      NULL,
      97,
      ' 5-28-1987',
      2.292570,
      61.299806,
      8,
      46.421595,
      ' 9-29-2001',
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      92.652220,
      47.890776,
      NULL,
      NULL,
      77.411598,
      0.972400,
      136,
      200.747949,
      4,
      85,
      0,
      48.169195,
      3.054843,
      1,
      56.507161,
      0.868151,
      0,
      57.683182,
      1,
      0,
      102.619036,
      6.396794,
      3.830836,
      171.762473,
      NULL,
      5.528360,
      NULL,
      NULL,
      49,
      1,
      0.286792,
      1,
      0.509605,
      0.653531,
      1,
      68.750411,
      103,
      68,
      8,
      70.226095,
      62.938831,
      0,
      0.039856,
      15,
      1,
      2,
      0,
      11.552991,
      4,
      19.004609,
      3.008359,
      NULL,
      1.435472,
      1,
      55,
      NULL,
      19.426708,
      17,
      70.579645,
      30,
      NULL,
      49.542865,
      0.616047,
      NULL,
      1.753055,
      0,
      1,
      1.250228,
      0,
      1,
      32,
      '11-11-1999',
      ' 1- 8-1982',
      ' 9-22-1998',
      ' 3-24-1993',
      ' 0-12-1976',
      ' 7- 1-1999',
      ' 7-23-1982',
      NULL);
commit;
end;
/


