set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9220725';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2341',
      '33341243',
      NULL,
      '33210111',
      '22102140',
      '22041420',
      NULL,
      NULL,
      '01324222',
      '24233104',
      '21221212',
      '24120340',
      '13330013',
      '23143041',
      '41444220',
      '20303221',
      '14402303',
      '44113124',
      '24222204',
      NULL,
      NULL,
      '24030434',
      '40413303',
      '31303224',
      '40214422',
      NULL,
      '30114044',
      '00324110',
      '31332243',
      '40333010',
      '00121442',
      '33123232',
      '02124242',
      '30143420',
      '44213020',
      '30113340',
      '43241213',
      '11024400',
      '33230043',
      '13310324',
      '41313100',
      '40122231',
      '13223221',
      '11231322',
      '10110222',
      '022',
      NULL,
      NULL,
      NULL,
      '1122442',
      3,
      1.215034,
      3,
      NULL,
      NULL,
      3.804600,
      '10-22-1995',
      '10- 6-2001',
      NULL,
      NULL,
      6,
      8,
      16,
      NULL,
      NULL,
      NULL,
      1.846903,
      13.768521,
      12,
      NULL,
      5,
      NULL,
      1.430356,
      7,
      8,
      30.130708,
      28.024882,
      NULL,
      46,
      4,
      83,
      NULL,
      0,
      12.679869,
      183.949035,
      95,
      42.841250,
      10,
      55.273472,
      ' 5-10-1975',
      57.035501,
      16,
      28,
      7.506462,
      155,
      13.036954,
      '11- 6-1986',
      0.345831,
      1.494004,
      1,
      0.195985,
      0.524576,
      0,
      1.670684,
      1,
      0.848127,
      1,
      0.932159,
      0.559887,
      1.761096,
      1.795394,
      1.227384,
      1.672530,
      0,
      0,
      1.292360,
      1.316537,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-29-1988',
      20,
      NULL,
      7.561872,
      6.718090,
      11,
      4.476953,
      ' 6-17-1976',
      0.961729,
      1.356786,
      176,
      0,
      3.356353,
      101.698825,
      1,
      0.321157,
      55.778867,
      1,
      0.884032,
      NULL,
      '11- 9-1995',
      102,
      NULL,
      97,
      70,
      35,
      111,
      51,
      106.065350,
      NULL,
      98,
      65,
      9.220934,
      '10- 7-1987',
      NULL,
      11.963330,
      27,
      47.334102,
      NULL,
      53.573917,
      NULL,
      ' 0- 1-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.765530,
      NULL,
      NULL,
      12,
      8.693966,
      NULL,
      28.948496,
      0.769048,
      ' 3- 8-1980',
      24,
      ' 7-17-1985',
      28.578747,
      '11-24-2000',
      7,
      15.753216,
      ' 0-22-1974',
      NULL,
      39,
      ' 0-23-2000',
      NULL,
      0.579662,
      ' 7- 9-1999',
      4,
      NULL,
      NULL,
      1,
      3,
      9,
      ' 6- 2-1986',
      67.072592,
      3,
      3.165291,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5);
commit;
end;
/


