set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8925188';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1220',
      '40143102',
      '32323124',
      NULL,
      '24433024',
      '43214202',
      '12403203',
      NULL,
      '02000444',
      NULL,
      '13241203',
      '22424011',
      '10020434',
      '40420414',
      '34221024',
      '20040234',
      '40222103',
      '10304313',
      '14143141',
      '31044403',
      '03331223',
      NULL,
      '33404401',
      '33403213',
      '11303143',
      '23103034',
      '11400110',
      '23312341',
      '40101300',
      NULL,
      '24132110',
      '20041342',
      '30120203',
      '32414124',
      NULL,
      '40342433',
      '03140302',
      '14433333',
      '31222141',
      '11432422',
      NULL,
      '01444322',
      '01403231',
      '44432104',
      '00003043',
      '',
      '',
      NULL,
      NULL,
      '1001314',
      0.642157,
      1,
      NULL,
      NULL,
      '044201',
      0.382480,
      '11-10-1982',
      ' 8-14-1994',
      14.183893,
      NULL,
      7,
      6.960637,
      NULL,
      NULL,
      12.311487,
      5,
      15.936730,
      NULL,
      1,
      8,
      6,
      NULL,
      NULL,
      5.727602,
      0,
      8.614142,
      11.544780,
      6,
      9,
      14,
      20,
      5.886688,
      NULL,
      10.041267,
      NULL,
      51.322568,
      83.980731,
      30.452737,
      38,
      ' 1-24-1985',
      41.044522,
      8,
      3.549038,
      10.239595,
      109,
      171.653404,
      ' 7- 1-2003',
      9,
      5,
      NULL,
      1.499495,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.771227,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-11-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-22-1994',
      NULL,
      67.717404,
      24,
      89,
      3,
      37,
      NULL,
      10.165277,
      NULL,
      60.947445,
      21.280257,
      NULL,
      ' 7- 9-1993',
      NULL,
      6,
      8.841364,
      47,
      2.005091,
      12,
      6,
      ' 1-21-1986',
      13.566221,
      3.568467,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      60.414635,
      28.245262,
      3.415787,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 8-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      54,
      16,
      6.533081,
      '11-17-1981',
      0.141397,
      105,
      ' 6- 7-1988',
      8,
      NULL,
      6,
      32.443689,
      ' 2-22-1986',
      8.660702,
      3,
      140.942176,
      ' 5-22-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      17,
      5.557632,
      79.181608,
      24,
      NULL,
      80,
      131.795032,
      2.543243,
      4,
      0,
      109.390204,
      NULL,
      7,
      100,
      5,
      3.267680,
      82,
      NULL,
      5,
      NULL,
      13,
      1,
      227.409372,
      2,
      10.697309,
      NULL,
      0.242805,
      41.046294,
      NULL,
      NULL,
      1.857061,
      2,
      1.988085,
      1,
      54.928860,
      26.511401,
      26,
      NULL,
      48,
      25,
      1,
      17.124847,
      5,
      1,
      0.919427,
      7,
      9.044667,
      1.297461,
      38,
      NULL,
      74.230474,
      NULL,
      1,
      105,
      8.731981,
      NULL,
      19.318914,
      17.284075,
      80.005995,
      NULL,
      NULL,
      9,
      8,
      1.620033,
      5.415941,
      0.153798,
      NULL,
      0.285082,
      4.424396,
      1.358067,
      '11-19-1977',
      ' 5- 8-1995',
      NULL,
      NULL,
      '10-25-1979',
      NULL,
      ' 8- 8-1998',
      NULL);
commit;
end;
/


