set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8925188';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4400',
      '40131234',
      NULL,
      NULL,
      '30044020',
      '22003314',
      NULL,
      NULL,
      '20200340',
      NULL,
      '42113223',
      '34014413',
      '02202011',
      NULL,
      '13414101',
      '11144113',
      '34140404',
      '30334332',
      NULL,
      '31141201',
      '33312440',
      '12113034',
      '13240230',
      '13200303',
      NULL,
      '31024021',
      '33013243',
      '12120022',
      '34221044',
      NULL,
      '40043343',
      '32330112',
      NULL,
      '23404232',
      '42101012',
      '12342334',
      '00003202',
      '21333233',
      '04301312',
      '10021041',
      '01230413',
      '04033211',
      '22140422',
      '13410303',
      '33210203',
      '',
      '',
      NULL,
      NULL,
      '0031410',
      0,
      3.816701,
      3,
      NULL,
      '430230',
      0,
      NULL,
      NULL,
      25.832475,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      39.842268,
      NULL,
      17.287359,
      20,
      17,
      16,
      ' 9-16-1993',
      NULL,
      0.480860,
      6.852634,
      0.184263,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.093358,
      1.490506,
      1.042475,
      1.269990,
      0.230528,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-22-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      42,
      97,
      NULL,
      98.559676,
      64.727015,
      17,
      NULL,
      100,
      107.681530,
      13.024288,
      35.857841,
      46,
      ' 7- 8-1982',
      8,
      15,
      2.609891,
      51.660190,
      45,
      5.018242,
      8,
      ' 2- 8-1991',
      7,
      NULL,
      ' 9-12-1992',
      9.196256,
      6.075124,
      9.131983,
      2,
      13,
      11,
      NULL,
      14.714190,
      NULL,
      16.701714,
      2,
      2,
      3.880918,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 3-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      91.147318,
      ' 5- 7-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      35,
      NULL,
      1,
      83,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.395900,
      NULL,
      0.044107,
      1,
      161.133677,
      0.971408,
      0.234168,
      77.336274,
      NULL,
      NULL,
      74.472422,
      83.547372,
      NULL,
      NULL,
      0.678023,
      76.442324,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      28.239338,
      NULL,
      NULL,
      NULL,
      16.515174,
      NULL,
      NULL,
      NULL,
      1.880243,
      0.107989,
      0,
      39,
      0.845469,
      NULL,
      1.448212,
      3.941256,
      NULL,
      NULL,
      41,
      18,
      NULL,
      34,
      86,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.969228,
      1.328247,
      1,
      2,
      47,
      NULL,
      NULL,
      NULL,
      ' 5-16-1998',
      NULL,
      NULL,
      ' 0-18-1985',
      NULL);
commit;
end;
/


