set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8925188';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3200',
      '03431313',
      '03221424',
      NULL,
      '12113110',
      NULL,
      '02004441',
      '04422303',
      '30042220',
      '32112331',
      '24110344',
      NULL,
      '10220320',
      '43004301',
      '10330422',
      '11224240',
      '34214113',
      NULL,
      '11301230',
      '33242413',
      '43113313',
      '32201333',
      '40013042',
      '31221004',
      '10413332',
      '22034234',
      '40234102',
      '40012403',
      '32100434',
      '33233134',
      NULL,
      '30214430',
      NULL,
      '00230221',
      '44100430',
      '41000344',
      NULL,
      '04444120',
      '24233320',
      '02014242',
      '20111310',
      '12121001',
      '10320013',
      NULL,
      '13444004',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      0.901093,
      6.058992,
      1,
      NULL,
      '042332',
      1.354701,
      NULL,
      '10- 5-2000',
      39.492214,
      NULL,
      0,
      9,
      29.007909,
      NULL,
      24,
      2.617612,
      8.359515,
      0.462911,
      2,
      5.257930,
      NULL,
      0,
      11.985784,
      NULL,
      24.251395,
      9.313508,
      28.072693,
      9,
      38.869453,
      20,
      0,
      13,
      NULL,
      45.202308,
      NULL,
      81,
      NULL,
      58.894346,
      118,
      ' 6-23-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.961583,
      0.756438,
      NULL,
      NULL,
      NULL,
      NULL,
      1.012521,
      NULL,
      4,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-20-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      41,
      56.250504,
      16,
      68.096503,
      1,
      7.351487,
      69.098142,
      37,
      44.509604,
      NULL,
      55.503123,
      NULL,
      17.793925,
      8.493984,
      0.312372,
      3,
      12.417409,
      NULL,
      NULL,
      ' 4-29-1999',
      NULL,
      13.582775,
      ' 5-28-1998',
      1.766364,
      17,
      15,
      13,
      1.373083,
      8.403204,
      NULL,
      12.291846,
      NULL,
      83.902523,
      3.173395,
      1,
      15,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 0-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      71,
      15.981936,
      29.450310,
      NULL,
      1,
      13,
      ' 4-16-1993',
      0.782833,
      85.208496,
      5,
      45.604276,
      ' 8-17-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      51,
      NULL,
      8,
      NULL,
      119.416324,
      10.262033,
      67.585867,
      NULL,
      NULL,
      1.500049,
      51,
      0,
      1,
      NULL,
      0.587107,
      0,
      132.453767,
      NULL,
      0,
      59.890662,
      0,
      3,
      201.666849,
      6.993315,
      NULL,
      NULL,
      1,
      41,
      NULL,
      1,
      0.976677,
      NULL,
      0,
      0.186861,
      62,
      16.697402,
      NULL,
      NULL,
      NULL,
      110.077368,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.067385,
      36,
      1.547125,
      1,
      66,
      NULL,
      NULL,
      22.268100,
      21,
      97,
      NULL,
      NULL,
      6.658717,
      5.361575,
      1.475705,
      0.088660,
      3.466729,
      NULL,
      NULL,
      2.106080,
      92,
      ' 6-28-1981',
      NULL,
      NULL,
      NULL,
      '11- 6-1994',
      NULL,
      NULL,
      NULL);
commit;
end;
/


