set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9607352';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1302',
      '40412030',
      '11113314',
      '44100200',
      '44002143',
      NULL,
      '13200430',
      '30011144',
      '00414302',
      '23413200',
      '22111042',
      NULL,
      '03414141',
      '41311140',
      '33121220',
      '10342022',
      '11334310',
      NULL,
      '01043242',
      '13210410',
      '22434103',
      '41340241',
      '01233304',
      '23420012',
      '21320100',
      '40204304',
      '13130013',
      '24410302',
      '11314210',
      '43414013',
      '20030322',
      NULL,
      '24131133',
      '11022144',
      '11124043',
      NULL,
      '04413212',
      '04012132',
      '01302333',
      '34020440',
      '24033431',
      '11142042',
      '42413130',
      '03143240',
      '33304234',
      '324',
      '11',
      20,
      NULL,
      '1030023',
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      ' 1- 2-1990',
      '10-14-1981',
      26.406233,
      NULL,
      47,
      NULL,
      41,
      5,
      NULL,
      13.674118,
      20.188528,
      NULL,
      NULL,
      26.645856,
      22,
      18.893221,
      32,
      NULL,
      5,
      NULL,
      21,
      11,
      55.578985,
      22.331357,
      84,
      NULL,
      1.227930,
      130.425277,
      187.139740,
      47,
      100,
      255,
      45.090196,
      ' 9-19-1992',
      12.158916,
      18.578131,
      9,
      30.174624,
      64.871788,
      81,
      ' 9-28-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      29.702445,
      NULL,
      0.262234,
      2,
      3.446003,
      '10- 5-1994',
      1,
      1.090503,
      51,
      0,
      NULL,
      8.055439,
      1,
      0.333036,
      61,
      NULL,
      NULL,
      NULL,
      ' 9-20-1993',
      29,
      NULL,
      59,
      5.796370,
      NULL,
      NULL,
      2.037546,
      NULL,
      NULL,
      NULL,
      21.644541,
      1,
      ' 1-23-2001',
      9,
      16.898507,
      7.586893,
      46.416632,
      78.377502,
      10,
      7.434628,
      ' 2- 3-1975',
      2,
      3.976542,
      NULL,
      5,
      NULL,
      NULL,
      3.057462,
      17,
      3,
      0.290767,
      6,
      0,
      120,
      NULL,
      NULL,
      16.976745,
      12,
      1.496239,
      NULL,
      NULL,
      0,
      ' 7-29-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      134,
      1.268496,
      '10- 0-2000',
      NULL,
      NULL,
      NULL,
      11,
      ' 8-22-1993',
      2,
      '10-10-1983',
      NULL,
      6,
      NULL,
      88.389145,
      112,
      ' 0-18-1982',
      NULL,
      NULL,
      ' 3- 5-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      26.619726,
      ' 0- 7-1987',
      33.474613,
      NULL,
      NULL,
      ' 7- 5-1981',
      1.028238,
      89,
      ' 6-11-1981',
      0,
      25.873562,
      18,
      19,
      ' 2-20-2000',
      24.379902,
      0,
      15,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


