set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9607352';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1443',
      NULL,
      NULL,
      '44134413',
      '20232424',
      '34132024',
      '21304204',
      '40444040',
      '01022223',
      '02124110',
      NULL,
      '32234012',
      NULL,
      '24032120',
      NULL,
      '32043441',
      '42001302',
      '34141421',
      '00144034',
      '00323011',
      NULL,
      '10412004',
      '32431123',
      '33413241',
      '43323121',
      '21142140',
      NULL,
      '31344322',
      '13231314',
      '24344040',
      NULL,
      NULL,
      '00014214',
      '00231204',
      '43431333',
      '14444432',
      '32144304',
      NULL,
      '30142013',
      '33230321',
      '13201233',
      '14231002',
      '03341241',
      '13213110',
      '01234331',
      '241',
      '24',
      19,
      0.438545,
      NULL,
      2.446757,
      NULL,
      1,
      NULL,
      '212111',
      5.618935,
      ' 5-18-1982',
      ' 6-27-1996',
      NULL,
      NULL,
      18.965795,
      8.010696,
      22,
      16.217449,
      25,
      8.170169,
      27,
      8,
      NULL,
      12.736340,
      28.034796,
      27,
      2,
      20,
      27.369099,
      7.913285,
      33,
      6.108348,
      33.208368,
      4,
      NULL,
      11.954323,
      0.672888,
      0.008605,
      46,
      22,
      NULL,
      NULL,
      147,
      '11- 0-1990',
      33,
      48.987225,
      39.846484,
      20.468835,
      35.937207,
      44.901012,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      106.742945,
      1,
      7,
      6,
      8.740285,
      1,
      NULL,
      1,
      NULL,
      178,
      0.877699,
      0.848035,
      95,
      NULL,
      NULL,
      85.234594,
      NULL,
      NULL,
      NULL,
      NULL,
      81,
      90.633675,
      NULL,
      13.300235,
      6.368088,
      63,
      20.011215,
      30,
      71.481565,
      29.475255,
      NULL,
      16,
      ' 3-13-1984',
      25.258689,
      21.919792,
      1,
      98.330412,
      16.450453,
      112,
      NULL,
      NULL,
      25,
      10,
      ' 0-11-2003',
      11.095478,
      7.158726,
      NULL,
      NULL,
      15.778076,
      NULL,
      0,
      10,
      1,
      NULL,
      3.402146,
      9,
      10.480220,
      2,
      0.630827,
      0,
      2,
      1.417331,
      ' 0-12-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      65,
      5,
      ' 8- 1-1998',
      NULL,
      NULL,
      NULL,
      43.089389,
      '10-21-1975',
      39.659524,
      ' 0-23-1982',
      8,
      3,
      ' 6-10-1991',
      134.684210,
      55.965915,
      ' 7-28-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      11,
      NULL,
      6.141536,
      7,
      2,
      NULL,
      NULL,
      NULL,
      ' 5-12-1992',
      8,
      17,
      NULL,
      31.538103,
      ' 1-24-1979',
      NULL,
      0.016903,
      NULL,
      ' 7- 4-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


