set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7306287';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2144',
      NULL,
      '34414133',
      NULL,
      '24132014',
      '23124204',
      '14032331',
      '44133000',
      '14311123',
      NULL,
      '20033204',
      NULL,
      '11141033',
      NULL,
      '01244322',
      '42222020',
      '30241313',
      '33420443',
      NULL,
      '23343212',
      '13101231',
      '42033130',
      '00101103',
      '44113113',
      '10431033',
      '21420030',
      '33342213',
      '31301402',
      '23034234',
      '41140421',
      '14440123',
      '12220422',
      '01102020',
      '00340011',
      '40243012',
      '23120014',
      '32104122',
      '44314403',
      '14404022',
      '14004110',
      '12131302',
      '03123341',
      '20101121',
      NULL,
      '43023224',
      '232',
      '41',
      NULL,
      NULL,
      '4404020',
      2.310803,
      0,
      2,
      NULL,
      '040303',
      4.401832,
      NULL,
      ' 8- 9-2001',
      128.979629,
      NULL,
      17.519113,
      24.156761,
      20.834728,
      12.619306,
      108.979677,
      20,
      19,
      31.287324,
      43,
      NULL,
      16,
      8,
      16,
      15,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.415822,
      NULL,
      20,
      NULL,
      140.227231,
      103.320429,
      77,
      NULL,
      90,
      134.230645,
      ' 7- 6-1981',
      26.793141,
      52.455831,
      39,
      7,
      125.538266,
      31,
      ' 5- 3-1981',
      3,
      3.729534,
      NULL,
      1,
      NULL,
      1.277373,
      0.093194,
      2,
      1.800618,
      NULL,
      4.243221,
      NULL,
      1,
      0,
      0.727493,
      0.035097,
      NULL,
      0.556700,
      0.614965,
      2.639118,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      73.063508,
      NULL,
      12,
      9.714337,
      NULL,
      NULL,
      NULL,
      1,
      0.490698,
      NULL,
      0.131881,
      2,
      79,
      NULL,
      2.624700,
      NULL,
      0.080434,
      0.947519,
      131,
      ' 9- 5-1998',
      NULL,
      NULL,
      35,
      NULL,
      44.665391,
      55.696457,
      NULL,
      80,
      NULL,
      48,
      107.687482,
      45.298659,
      '10- 5-1995',
      5,
      5.025134,
      7.648095,
      45,
      29,
      9.654706,
      3.957050,
      '10-16-1978',
      11.127261,
      17,
      ' 9-22-1999',
      13,
      NULL,
      4.798693,
      11,
      NULL,
      0.813527,
      NULL,
      NULL,
      0.408199,
      NULL,
      1.267191,
      1.748871,
      NULL,
      4.867317,
      0,
      0.050165,
      0.311174,
      1,
      '11-19-1978',
      5.956527,
      3.027056,
      1.864185,
      NULL,
      NULL,
      13,
      '10- 9-1978',
      NULL,
      4,
      ' 8-10-1996',
      39.747334,
      ' 9-23-1996',
      49.521990,
      ' 0- 8-1983',
      18.619199,
      16,
      '10-25-1986',
      NULL,
      50,
      ' 6- 0-2001',
      NULL,
      NULL,
      ' 8-17-1982',
      2,
      8,
      ' 9-16-1987',
      NULL,
      1,
      23,
      ' 0- 8-2003',
      50,
      41,
      38,
      ' 3-21-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13.416028);
commit;
end;
/


