set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9621028';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0032',
      '22400100',
      '40132404',
      '31231314',
      '02031201',
      '24202322',
      '02220012',
      NULL,
      '03244414',
      '02232013',
      '00400410',
      '24020133',
      NULL,
      '24041204',
      NULL,
      NULL,
      '03244044',
      '02100021',
      '23023013',
      NULL,
      '31100300',
      '01220143',
      '43444134',
      NULL,
      '01333210',
      NULL,
      '41141143',
      '00301101',
      '43142004',
      '30030201',
      '00332201',
      '34004334',
      '11211042',
      '40341133',
      '14310444',
      '04423202',
      '20323201',
      '03001240',
      '10343311',
      '24323312',
      '04142420',
      NULL,
      '24444133',
      '24030333',
      NULL,
      NULL,
      NULL,
      2.557992,
      NULL,
      '4214042',
      1.498326,
      0,
      0,
      NULL,
      NULL,
      1.490104,
      NULL,
      '10-18-2000',
      NULL,
      NULL,
      31.690420,
      2.173252,
      16,
      9.644706,
      51.750194,
      7.644606,
      21.350867,
      NULL,
      13,
      12.860971,
      21.650133,
      10.622499,
      4,
      0,
      14.766530,
      8.237684,
      52,
      9.950681,
      0.570806,
      11.347327,
      14.272522,
      8.751746,
      1.934986,
      70,
      147.858519,
      13.499690,
      53,
      71.926917,
      NULL,
      NULL,
      40,
      11,
      NULL,
      9.376508,
      169,
      NULL,
      ' 5- 0-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      42.697364,
      NULL,
      16,
      NULL,
      9.544769,
      1,
      ' 0-13-1982',
      0,
      0,
      58.551408,
      0,
      1,
      93.747721,
      0.048948,
      NULL,
      39,
      NULL,
      NULL,
      NULL,
      NULL,
      51,
      47.956303,
      63,
      47,
      73.218538,
      100.829043,
      6,
      51,
      NULL,
      55.406141,
      NULL,
      114.235883,
      ' 5- 8-1990',
      1.798146,
      4.009948,
      23.522022,
      2.060745,
      NULL,
      35.675935,
      0,
      '11-25-1977',
      NULL,
      29,
      '11-24-1987',
      7,
      5,
      14,
      NULL,
      NULL,
      NULL,
      1.708851,
      6,
      1.379320,
      4,
      NULL,
      3,
      10,
      2,
      NULL,
      25,
      NULL,
      1,
      ' 0-24-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      94,
      1.629946,
      ' 3- 6-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-17-2003',
      20,
      NULL,
      20,
      2.563205,
      ' 9- 0-2003',
      67,
      64,
      ' 5-19-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      12,
      ' 8-29-1985',
      NULL,
      9,
      33.168387,
      ' 1-24-1994',
      0.181912,
      235,
      ' 2-18-1993',
      8.810255,
      42.571026,
      NULL,
      141.524148,
      ' 0-25-2001',
      40,
      0.125214,
      146,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


