set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9621028';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1041',
      NULL,
      '24442234',
      NULL,
      '43340334',
      '23440310',
      '04134004',
      NULL,
      '31230003',
      '01042130',
      '01121211',
      NULL,
      '02443211',
      NULL,
      '00212313',
      '11333213',
      '11233414',
      NULL,
      '00031404',
      '22410002',
      NULL,
      '04033313',
      NULL,
      '41012214',
      NULL,
      NULL,
      '30241443',
      '01340021',
      NULL,
      '24333104',
      '00021330',
      '11343231',
      '44304141',
      '03223042',
      '31433000',
      '44142002',
      '43134313',
      '02332233',
      '00414300',
      NULL,
      NULL,
      '41421014',
      '13342312',
      '24323242',
      '14123223',
      '031',
      '44',
      33,
      NULL,
      '2114102',
      3.336554,
      36.648589,
      NULL,
      NULL,
      NULL,
      5,
      ' 5-28-1981',
      ' 2- 3-1989',
      NULL,
      83,
      26,
      21.776154,
      16,
      16,
      49.940106,
      16.792993,
      25,
      22.894792,
      6.345264,
      0,
      13,
      12,
      NULL,
      NULL,
      5,
      9,
      5.491926,
      17.542505,
      44.653475,
      15.370206,
      84,
      22,
      0,
      41.462210,
      28,
      28,
      NULL,
      152,
      NULL,
      '11-22-1997',
      13.253338,
      25.093274,
      NULL,
      3.046252,
      NULL,
      183.521872,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      30.788067,
      13,
      2.558112,
      0,
      3,
      7.375733,
      '11-15-1994',
      NULL,
      0,
      113,
      1.471300,
      1,
      99,
      3,
      0.276612,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4- 4-1999',
      27.942384,
      57.057470,
      59.478280,
      55,
      55.613438,
      32.613374,
      19,
      NULL,
      45,
      95,
      21.839590,
      85,
      '11-23-1986',
      10,
      12,
      2.699156,
      32,
      69.531957,
      41.463488,
      7,
      ' 6-15-2003',
      14.730397,
      2.258776,
      ' 2-22-1995',
      2,
      7.703491,
      NULL,
      4.374772,
      23,
      7.922489,
      1,
      NULL,
      1,
      76.282637,
      1.240038,
      2.508495,
      13.754220,
      2,
      3,
      NULL,
      0,
      NULL,
      '11-26-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.506294,
      NULL,
      NULL,
      NULL,
      NULL,
      35.107310,
      ' 9-11-1998',
      1.715582,
      NULL,
      9,
      7,
      ' 5-25-1988',
      3.118737,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      5,
      ' 9-10-1981',
      24.607676,
      13.772567,
      33.079708,
      ' 0-15-1988',
      NULL,
      NULL,
      ' 3-25-2001',
      NULL,
      11,
      23.672466,
      NULL,
      ' 6-29-1984',
      49,
      0.517709,
      67,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


