set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9026888';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '31014030',
      '14241403',
      '44433443',
      '23420222',
      '22221134',
      '20420324',
      '43144404',
      '40003400',
      '44300102',
      NULL,
      '32410424',
      NULL,
      '23212321',
      '00303240',
      '32210441',
      '04343142',
      '10322024',
      '41200444',
      '11021233',
      '11100124',
      '12232024',
      '03041300',
      '31220032',
      '44210121',
      NULL,
      '12404303',
      '41020232',
      NULL,
      '22241344',
      NULL,
      '12333434',
      '22110340',
      NULL,
      '12112432',
      '31134332',
      NULL,
      '01300200',
      NULL,
      '31104430',
      NULL,
      '22323241',
      '02202304',
      '33343303',
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      0.481777,
      1.943408,
      1,
      NULL,
      '413104',
      3,
      ' 2- 1-1979',
      ' 0- 3-1999',
      103,
      NULL,
      14.597810,
      8,
      18,
      2,
      84.537735,
      11.501340,
      7.782668,
      NULL,
      NULL,
      13,
      9,
      1.972558,
      NULL,
      6.650778,
      19.662056,
      15,
      8,
      NULL,
      38.531840,
      9,
      65.289952,
      11,
      NULL,
      86,
      49.799389,
      NULL,
      13,
      124,
      50.651117,
      ' 1-19-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.338309,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.337623,
      1.358427,
      2,
      0.760790,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-18-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-25-1982',
      133.534208,
      26.421576,
      7,
      4.838803,
      25,
      104.968717,
      NULL,
      46.590451,
      68.556211,
      81,
      34.324685,
      62,
      ' 1- 2-1995',
      8.415542,
      3.681809,
      15.005923,
      52,
      49,
      42,
      2,
      ' 8-28-1993',
      3.575734,
      1,
      ' 3-20-1987',
      4,
      5.674564,
      0.679144,
      0.552105,
      14.479236,
      4.555663,
      NULL,
      0.017182,
      NULL,
      NULL,
      5.035867,
      4,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 9-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12,
      NULL,
      ' 3-28-1996',
      NULL,
      50,
      ' 5- 6-1974',
      3,
      1,
      1.153150,
      5.984322,
      NULL,
      48.564276,
      0,
      114,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      83,
      41.286320,
      27,
      1,
      38,
      11.332503,
      10.860084,
      NULL,
      NULL,
      8.509757,
      96.029999,
      0,
      1,
      46.287297,
      NULL,
      NULL,
      NULL,
      3,
      0.125944,
      80.437894,
      NULL,
      1,
      214.943596,
      58,
      12.679651,
      NULL,
      0,
      22.968972,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.413075,
      75,
      93.263873,
      111,
      19,
      70.242956,
      30,
      NULL,
      1,
      NULL,
      NULL,
      1.827562,
      0.270420,
      NULL,
      NULL,
      NULL,
      3,
      87.270523,
      0,
      NULL,
      NULL,
      6,
      12,
      16.434122,
      12.499980,
      16.817167,
      21,
      6.951670,
      NULL,
      11.088745,
      3.159933,
      2,
      1,
      3.307320,
      NULL,
      0,
      85.821868,
      ' 9-25-1998',
      '10- 4-1987',
      '10-23-1981',
      NULL,
      NULL,
      '10-14-1977',
      ' 6-20-1978',
      NULL);
commit;
end;
/


