set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8829507';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3222',
      '42431420',
      '44422220',
      '30101304',
      '21423334',
      NULL,
      '13401341',
      '13414130',
      NULL,
      '41340042',
      '41440141',
      '01300241',
      '23221032',
      '21322141',
      '21341321',
      '30313040',
      NULL,
      '43413103',
      '34240021',
      '41243433',
      '10201233',
      '33411211',
      '34332032',
      '00202302',
      '01121221',
      '24420030',
      '12303020',
      NULL,
      '30404002',
      '10011341',
      NULL,
      '42103314',
      '42140212',
      NULL,
      '00102202',
      '02200210',
      NULL,
      '41203212',
      '34231030',
      '20014243',
      '13021011',
      '12241322',
      '04033402',
      '44414011',
      '12001244',
      '',
      '',
      NULL,
      NULL,
      NULL,
      0.703952,
      NULL,
      2,
      NULL,
      '033003',
      2.991611,
      ' 0- 7-1978',
      ' 7- 1-1998',
      1,
      NULL,
      31.817337,
      11.518203,
      18,
      NULL,
      29,
      14.642903,
      6,
      13,
      9.659499,
      9,
      16,
      7,
      22.103988,
      14.982079,
      NULL,
      10.188134,
      26,
      NULL,
      31,
      NULL,
      2.670749,
      9,
      NULL,
      88,
      27.504048,
      44.147445,
      80.464676,
      191.148326,
      NULL,
      ' 9-19-1992',
      NULL,
      61,
      2.454553,
      16.592951,
      136.307407,
      70.159756,
      ' 6-14-1975',
      1,
      0.443278,
      6.226270,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.502349,
      NULL,
      NULL,
      NULL,
      0,
      1.435648,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 4-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1- 1-1994',
      121.799717,
      4,
      49,
      NULL,
      1.465049,
      NULL,
      103,
      NULL,
      63.621194,
      61.132829,
      55.347134,
      59,
      '10-19-1978',
      21.820851,
      20,
      15.780725,
      NULL,
      NULL,
      36,
      4,
      ' 7-20-1982',
      12.711986,
      4.281706,
      '11- 1-1975',
      6.249719,
      NULL,
      9.363451,
      5.373401,
      8.672990,
      0.188028,
      NULL,
      6.139333,
      NULL,
      NULL,
      3,
      0.703543,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 1-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      27.033490,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19.406763,
      16.554589,
      ' 0- 7-2003',
      1,
      1,
      NULL,
      '11- 6-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      43,
      0,
      20,
      39.529064,
      76.903457,
      NULL,
      NULL,
      9,
      0,
      5.092285,
      59.513692,
      NULL,
      0,
      17,
      0.540972,
      NULL,
      37,
      NULL,
      5.770832,
      45.960257,
      0,
      0.486139,
      49.515968,
      17.471155,
      22.308731,
      31.408669,
      NULL,
      NULL,
      1,
      1,
      0.252505,
      0.726484,
      NULL,
      0,
      2.574741,
      NULL,
      69,
      NULL,
      NULL,
      24.600941,
      NULL,
      0.879332,
      NULL,
      1.885677,
      1,
      0,
      31.278612,
      1,
      10.732609,
      NULL,
      62.323140,
      1,
      0.592753,
      53,
      NULL,
      NULL,
      6,
      51,
      32.381345,
      7.666106,
      23.932675,
      11.354178,
      NULL,
      1,
      1.118735,
      1.733500,
      1,
      1,
      0,
      27.457454,
      ' 1- 5-1980',
      '11-19-1997',
      ' 1-20-1985',
      ' 2- 0-1975',
      '10-10-1989',
      ' 1- 9-1994',
      ' 9-18-1991',
      NULL);
commit;
end;
/


