set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9687597';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '3',
      '1',
      '1',
      NULL,
      '0',
      NULL,
      '4',
      '0',
      '0',
      '3',
      '2',
      NULL,
      '4',
      '3',
      '1',
      '3',
      '3',
      '3',
      '3',
      '0',
      NULL,
      '0',
      '3',
      '',
      '1',
      '',
      NULL,
      '4',
      '1',
      '3',
      '3',
      '',
      '',
      '3',
      '4',
      NULL,
      '2',
      NULL,
      NULL,
      '2',
      '2',
      '2',
      '2',
      '2',
      '102',
      '10312443',
      34.102612,
      49,
      '0222220',
      NULL,
      1.613818,
      1,
      NULL,
      NULL,
      3.525296,
      ' 9-16-1986',
      ' 3- 8-1977',
      2.107877,
      59,
      15.875519,
      12.053934,
      21.905631,
      7,
      57,
      16,
      1,
      4.189856,
      22,
      11,
      NULL,
      17,
      36,
      NULL,
      NULL,
      7.768424,
      NULL,
      6.362203,
      27.306112,
      23.409883,
      66.953279,
      16.967506,
      1.546276,
      66,
      17.142611,
      NULL,
      105,
      75,
      134,
      ' 5-26-2000',
      32.137376,
      69.213439,
      32,
      29.470351,
      1,
      129,
      ' 8-19-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      28,
      9.107940,
      17,
      7.477914,
      0.324652,
      7,
      ' 3- 8-1999',
      NULL,
      1,
      81,
      NULL,
      1,
      38.551416,
      0,
      3,
      119,
      NULL,
      NULL,
      NULL,
      ' 3-16-1991',
      NULL,
      NULL,
      17,
      NULL,
      1,
      NULL,
      NULL,
      47,
      91.187777,
      4.227692,
      71.013973,
      84,
      ' 9- 3-1978',
      28,
      17,
      31,
      NULL,
      2,
      154,
      NULL,
      ' 4-13-1975',
      21,
      11,
      '11-10-1978',
      1.068421,
      7.888216,
      14.360152,
      28.280439,
      NULL,
      NULL,
      0.935168,
      22.405467,
      1.920267,
      NULL,
      0.799922,
      NULL,
      29.455315,
      NULL,
      1,
      0,
      0,
      1.716706,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.374880,
      ' 4-20-1987',
      NULL,
      NULL,
      NULL,
      11.156931,
      NULL,
      20,
      ' 7- 9-1974',
      14,
      14.640949,
      '11-28-1987',
      34,
      68.324247,
      ' 3-26-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      20.443029,
      ' 9- 9-1993',
      49,
      NULL,
      56.715693,
      ' 4- 1-1999',
      0.745396,
      NULL,
      '11-28-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


