set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9409102';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2320',
      '32343222',
      '13044321',
      '42014041',
      '22430322',
      NULL,
      '31434230',
      '24334413',
      '11232104',
      '13030011',
      '31402320',
      NULL,
      '02132343',
      '10243421',
      '03433330',
      '44122402',
      '43403042',
      '03113221',
      '13121011',
      '20333023',
      '42041110',
      '01033031',
      '42012202',
      '41414142',
      '13200323',
      NULL,
      '43010043',
      '41010040',
      NULL,
      NULL,
      NULL,
      '34333104',
      NULL,
      '23244202',
      NULL,
      '23240044',
      '40441120',
      '04214321',
      '14022231',
      '23220424',
      '30434211',
      '04411143',
      NULL,
      NULL,
      '13400331',
      '210',
      NULL,
      NULL,
      NULL,
      '4431223',
      NULL,
      1,
      NULL,
      NULL,
      '043233',
      NULL,
      NULL,
      ' 8- 4-1976',
      NULL,
      NULL,
      34,
      2.862466,
      2.945323,
      13,
      41.246629,
      NULL,
      20,
      1.799226,
      18.796977,
      9,
      19,
      NULL,
      22,
      20,
      NULL,
      13,
      NULL,
      11.491112,
      NULL,
      24,
      30,
      16.222535,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      113.624798,
      163.817052,
      ' 6- 9-1994',
      22,
      14,
      22.148148,
      19,
      136,
      28.702704,
      ' 5-20-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      35,
      27.065048,
      0,
      7.730865,
      10.451550,
      1.207092,
      '11-13-1983',
      0.083024,
      NULL,
      92.114054,
      0,
      1,
      NULL,
      0,
      1.532536,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 1-1975',
      21.260195,
      62.967930,
      2,
      46.038824,
      90,
      5.874633,
      54.592285,
      51.943402,
      69,
      NULL,
      77.433667,
      NULL,
      NULL,
      15,
      12.595603,
      NULL,
      40,
      60.264147,
      2.094085,
      2,
      ' 6-25-1982',
      1.158907,
      9.293384,
      ' 0- 7-1995',
      11,
      NULL,
      19.168199,
      NULL,
      26.432427,
      NULL,
      1,
      25.690181,
      1.488084,
      117,
      2.063140,
      NULL,
      NULL,
      17.316319,
      1,
      0.214818,
      1.992151,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      23,
      11,
      ' 6-18-1997',
      NULL,
      NULL,
      NULL,
      50.534160,
      NULL,
      18,
      ' 7-27-1975',
      NULL,
      3,
      ' 1- 4-1975',
      57.893347,
      33,
      ' 7-11-1987',
      NULL,
      NULL,
      ' 4- 3-1976',
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      ' 7-28-1980',
      42,
      32.541764,
      NULL,
      ' 8-15-1995',
      1,
      7.935078,
      ' 0- 8-2001',
      NULL,
      2,
      0.554474,
      51.093293,
      '10-21-1978',
      41,
      0.684366,
      108,
      ' 5-23-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


