set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9409102';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      '04313032',
      NULL,
      '34244202',
      '31314021',
      '11400313',
      '33211042',
      '12021211',
      NULL,
      NULL,
      '24441413',
      NULL,
      '02110321',
      '31104222',
      '22043024',
      NULL,
      '14320120',
      '40411403',
      '12131310',
      '22243322',
      '04333422',
      '23330234',
      '10041040',
      '21433342',
      '02101134',
      '41400023',
      '12211141',
      '13040211',
      '24002003',
      '42134023',
      '33431111',
      '20300003',
      '13403232',
      '44133003',
      '03441341',
      NULL,
      '20342132',
      NULL,
      '24232033',
      '40413243',
      '34444434',
      '43113211',
      '12341001',
      '22303244',
      '430',
      '00',
      32.936471,
      12.618867,
      '0104224',
      0,
      NULL,
      3,
      NULL,
      '020224',
      3,
      ' 2- 1-1977',
      ' 7- 4-1986',
      54,
      NULL,
      10,
      3.749731,
      14.296747,
      0.596573,
      31,
      6.706401,
      16.188418,
      NULL,
      11,
      NULL,
      28.657736,
      22.040693,
      34.843764,
      NULL,
      NULL,
      3.196105,
      1,
      3,
      21.560523,
      21.089152,
      132.259387,
      20,
      0.544600,
      77.398626,
      130.568171,
      NULL,
      44.733006,
      15,
      86,
      NULL,
      38,
      8.590936,
      16.295066,
      NULL,
      51.632970,
      16,
      '10-22-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.871641,
      NULL,
      3,
      NULL,
      ' 1-26-1998',
      0,
      1.512250,
      139.722207,
      0,
      1.858600,
      97,
      0.196965,
      0,
      58,
      NULL,
      NULL,
      NULL,
      ' 7-27-2003',
      NULL,
      24,
      89.799964,
      21.408721,
      45.694755,
      7.302067,
      12,
      56,
      21,
      4.320412,
      49,
      58.737536,
      ' 6-24-1983',
      17.785198,
      3,
      20,
      NULL,
      NULL,
      33,
      3.536939,
      ' 3-24-1998',
      36,
      NULL,
      ' 6- 4-1976',
      NULL,
      6.644832,
      1.076373,
      3,
      10.824262,
      1.533664,
      NULL,
      9.053358,
      NULL,
      107,
      0,
      NULL,
      NULL,
      14,
      2,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      29,
      6.322052,
      ' 5-24-1989',
      NULL,
      NULL,
      NULL,
      35,
      ' 4-24-1996',
      18,
      ' 5-12-1992',
      2,
      NULL,
      ' 5- 9-1996',
      69,
      93.722010,
      ' 1-20-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      16.361913,
      ' 3-14-2000',
      NULL,
      20.134368,
      NULL,
      NULL,
      1,
      109.388195,
      NULL,
      5,
      26.064162,
      3.240138,
      21,
      ' 5-11-1997',
      50.844464,
      0,
      61,
      ' 7-28-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


