set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9409102';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '1',
      '0',
      '4',
      NULL,
      '4',
      '3',
      '4',
      '2',
      '1',
      '1',
      '2',
      '3',
      NULL,
      '4',
      '0',
      '0',
      '4',
      '1',
      '3',
      '4',
      '4',
      NULL,
      '2',
      '',
      '2',
      NULL,
      NULL,
      '1',
      '4',
      '4',
      NULL,
      '',
      '',
      '3',
      '0',
      '2',
      '2',
      '3',
      '0',
      NULL,
      '0',
      '4',
      '0',
      '2',
      '440',
      NULL,
      NULL,
      22.610030,
      '0104343',
      3.945529,
      112.158062,
      3,
      NULL,
      '114143',
      4,
      NULL,
      ' 2-20-1999',
      240,
      34.033135,
      26,
      7.850349,
      9.021098,
      13.571624,
      51,
      21.675634,
      NULL,
      23,
      24.516825,
      NULL,
      NULL,
      8.429280,
      28.832282,
      NULL,
      25,
      17,
      46.824836,
      NULL,
      12.777656,
      8,
      NULL,
      18.648500,
      1.013288,
      7.877941,
      45,
      54,
      162,
      77.059958,
      NULL,
      ' 2- 4-1993',
      19.048468,
      NULL,
      NULL,
      33.239662,
      61.909518,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12,
      0.773781,
      5,
      4,
      2,
      NULL,
      ' 9-24-1981',
      0.538312,
      NULL,
      153.070597,
      0.929124,
      0.163584,
      NULL,
      1,
      1,
      77.355954,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      21,
      NULL,
      17.374228,
      37.093268,
      21.292802,
      62,
      63,
      23,
      70,
      13,
      44.653772,
      NULL,
      21.265033,
      7,
      17.900546,
      46.611384,
      NULL,
      122,
      11.229607,
      ' 5-28-1976',
      40.944711,
      24.894844,
      NULL,
      NULL,
      19.033992,
      20.273765,
      24.145107,
      NULL,
      8.332597,
      0,
      3,
      0.789473,
      1.150551,
      1,
      NULL,
      2.790277,
      4,
      0,
      1,
      0,
      0.881590,
      ' 2- 7-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      141,
      0.669706,
      ' 5-18-1979',
      NULL,
      NULL,
      NULL,
      11,
      ' 7- 7-1974',
      16.682902,
      '11-24-1992',
      11.022457,
      14.903896,
      '11-14-1986',
      NULL,
      10,
      ' 0- 7-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      10.655865,
      ' 5-29-2000',
      67,
      43,
      NULL,
      ' 6- 4-1996',
      1,
      NULL,
      '11- 9-1987',
      8.470599,
      4.693042,
      NULL,
      26.516263,
      NULL,
      14,
      1,
      16.299027,
      ' 0- 8-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


