set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9409102';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '2',
      '1',
      '4',
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '4',
      NULL,
      '1',
      NULL,
      '0',
      '3',
      '3',
      '1',
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '',
      NULL,
      '2',
      '0',
      NULL,
      NULL,
      '',
      '',
      NULL,
      '0',
      '2',
      NULL,
      '0',
      '2',
      NULL,
      '0',
      '0',
      '0',
      '0',
      '111',
      '31340402',
      NULL,
      72,
      '2413332',
      NULL,
      87.283810,
      0,
      NULL,
      '444321',
      0.689162,
      NULL,
      ' 8-12-1991',
      97,
      NULL,
      1,
      NULL,
      11.324250,
      10.666273,
      0,
      21.865597,
      1,
      NULL,
      4.784281,
      12.248834,
      30.108137,
      NULL,
      29,
      18,
      26,
      6,
      63,
      24.240893,
      0.323943,
      10.142112,
      NULL,
      12.203948,
      0.200724,
      22,
      115.014964,
      97,
      97.898828,
      242,
      146.368040,
      ' 3- 5-1981',
      26,
      61,
      8,
      39,
      170.363219,
      81.476434,
      ' 2-12-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      91,
      4,
      1.918080,
      0,
      3,
      7,
      ' 7-14-1980',
      1.210143,
      1.762079,
      NULL,
      1.224850,
      3,
      NULL,
      NULL,
      1,
      85.384567,
      NULL,
      NULL,
      NULL,
      ' 6-19-1987',
      40,
      41,
      26,
      100.744720,
      0.994456,
      32,
      58.330103,
      NULL,
      NULL,
      55,
      NULL,
      74.291605,
      ' 1-14-1984',
      7.337179,
      30,
      NULL,
      63.175303,
      45.405087,
      117,
      6,
      '11- 3-2002',
      18.631641,
      NULL,
      ' 5-23-1995',
      7,
      26.756583,
      20,
      22,
      NULL,
      2.989009,
      NULL,
      15.323465,
      1,
      53,
      1,
      NULL,
      NULL,
      NULL,
      0.978785,
      1.751289,
      0.375003,
      0.974914,
      ' 1-11-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      27,
      ' 8-29-1995',
      NULL,
      NULL,
      NULL,
      50.109372,
      ' 8-29-1986',
      23.270795,
      ' 5-25-1981',
      16,
      1.113636,
      ' 4-11-1987',
      81.902010,
      90,
      ' 6- 5-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      7,
      ' 1- 0-1995',
      9.537776,
      34.392085,
      28,
      NULL,
      0,
      53.631660,
      '11-26-2001',
      0.778282,
      29,
      18.068959,
      NULL,
      ' 6-10-1976',
      NULL,
      1,
      13.583614,
      ' 9- 1-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


