set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9887642';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '0',
      '3',
      '4',
      '2',
      '0',
      '0',
      '0',
      '1',
      '1',
      '1',
      '0',
      '4',
      '1',
      '1',
      '3',
      '0',
      '1',
      '1',
      '1',
      '3',
      '1',
      NULL,
      '1',
      '',
      '1',
      '',
      '3',
      '3',
      '3',
      '2',
      '3',
      NULL,
      '',
      '3',
      NULL,
      '1',
      '4',
      NULL,
      '4',
      '2',
      NULL,
      '1',
      '2',
      '4',
      '422',
      NULL,
      NULL,
      1.179262,
      '0004024',
      NULL,
      0.977683,
      0,
      0,
      '103440',
      1,
      '11- 1-1991',
      NULL,
      64,
      231.801243,
      8,
      5.655914,
      24,
      15,
      18.125306,
      NULL,
      NULL,
      0,
      NULL,
      14.771052,
      43.420027,
      6.755046,
      13,
      NULL,
      9,
      2.082212,
      10,
      2,
      NULL,
      5,
      90.370342,
      2.314678,
      NULL,
      110.780083,
      106,
      48,
      NULL,
      141.217689,
      136,
      ' 1- 4-2000',
      60.127324,
      62,
      NULL,
      NULL,
      39.870413,
      23.388443,
      ' 3- 7-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      35.056644,
      44,
      14,
      0,
      43.850683,
      1.762268,
      ' 7- 5-2003',
      0.492115,
      5.487789,
      109,
      1,
      2.067585,
      122.135264,
      2.280000,
      1,
      0.877720,
      NULL,
      NULL,
      NULL,
      ' 2-15-1994',
      48.960216,
      76.216334,
      NULL,
      56.705225,
      14,
      NULL,
      1.460922,
      21,
      25,
      46.988290,
      90,
      27,
      NULL,
      15.037473,
      0,
      6,
      36,
      5.483990,
      NULL,
      0,
      '10- 5-1981',
      27.475871,
      3.123486,
      ' 8- 7-1995',
      1.545380,
      2,
      17,
      11.241162,
      0.900255,
      1.538611,
      1,
      7.607783,
      1,
      NULL,
      NULL,
      1,
      4,
      21.076729,
      0.754116,
      0.195941,
      1,
      0.686328,
      ' 6-11-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      99.459028,
      1,
      ' 2- 8-1982',
      NULL,
      NULL,
      NULL,
      11.922782,
      ' 7- 5-1987',
      NULL,
      '10-18-1997',
      NULL,
      13.835091,
      '11-11-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      21,
      NULL,
      55,
      14.046587,
      13.700298,
      ' 0-26-2001',
      1,
      55.122986,
      ' 9-12-1987',
      5.478132,
      31.372945,
      NULL,
      NULL,
      ' 7- 5-1992',
      63,
      0,
      58,
      ' 5-16-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


