set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9887642';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '3',
      '4',
      '3',
      NULL,
      '1',
      '4',
      '4',
      '4',
      '4',
      NULL,
      '2',
      NULL,
      '1',
      NULL,
      '3',
      '3',
      '4',
      '0',
      '0',
      '0',
      '3',
      '4',
      NULL,
      '',
      '0',
      '',
      '1',
      NULL,
      '0',
      '4',
      NULL,
      '',
      '',
      '4',
      '0',
      '0',
      '1',
      '0',
      NULL,
      '0',
      '4',
      '4',
      NULL,
      '4',
      '432',
      '42201201',
      19.062841,
      NULL,
      '0141120',
      0,
      26.769748,
      2,
      1,
      '011423',
      3.716693,
      ' 0-16-1985',
      ' 3- 1-2002',
      10,
      82,
      37,
      16.373344,
      28.397888,
      0.828358,
      66.155711,
      NULL,
      10,
      NULL,
      11.516944,
      NULL,
      NULL,
      4,
      8.485457,
      NULL,
      NULL,
      NULL,
      31,
      16,
      50.767683,
      19,
      90.974646,
      11,
      0.191045,
      71.068523,
      158.939443,
      102,
      0,
      NULL,
      167,
      ' 6-29-1989',
      40.657199,
      NULL,
      8.468275,
      19.379779,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.479509,
      42,
      50.386643,
      26.017550,
      20,
      3,
      ' 2-13-1982',
      NULL,
      1,
      NULL,
      1.152691,
      0.105606,
      11.575199,
      0.537512,
      0,
      70,
      NULL,
      NULL,
      NULL,
      ' 8-11-1995',
      97.375748,
      92,
      NULL,
      17,
      65,
      66,
      17.732325,
      35,
      4,
      13,
      21.195031,
      46,
      ' 4- 8-1985',
      26,
      10,
      5.582003,
      42.138304,
      59.188016,
      63.244455,
      2.793749,
      ' 3- 4-1988',
      NULL,
      21.768358,
      NULL,
      9,
      2,
      15.102855,
      3.682816,
      NULL,
      4.522139,
      1,
      18.322771,
      NULL,
      26,
      2.370904,
      0.002976,
      13.347781,
      6,
      NULL,
      0.802700,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      232.298053,
      17,
      '10- 8-1990',
      NULL,
      NULL,
      NULL,
      45.068092,
      ' 0- 7-1990',
      33.934318,
      ' 3- 1-1980',
      3.388737,
      4,
      ' 2-18-1978',
      117.076461,
      31.275991,
      '10-13-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4.704001,
      '10-20-1996',
      11,
      30.485069,
      23.161146,
      ' 9- 7-1997',
      1,
      117,
      ' 0- 4-2002',
      NULL,
      39.406787,
      11.299843,
      31,
      ' 3-29-1999',
      17.964503,
      1.901861,
      124,
      ' 9-28-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


