set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8834206';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2231',
      NULL,
      '14331324',
      NULL,
      '03141212',
      NULL,
      '02033401',
      NULL,
      '41212201',
      '23141000',
      '01031302',
      '00122103',
      '41401244',
      '12000432',
      NULL,
      '40312032',
      '40320031',
      NULL,
      '04333421',
      NULL,
      '12112241',
      NULL,
      '31211431',
      '14401232',
      NULL,
      '42324133',
      NULL,
      '41114231',
      '23324134',
      NULL,
      NULL,
      '42133324',
      '02222020',
      '10130341',
      '12034402',
      '13320344',
      NULL,
      '40210203',
      '34000021',
      '20322034',
      '30000123',
      '42114244',
      '31441433',
      '04132121',
      '21321222',
      '',
      '',
      NULL,
      NULL,
      '2331322',
      2,
      1,
      0,
      NULL,
      '402342',
      1.151584,
      '10-16-1985',
      NULL,
      NULL,
      NULL,
      2.010169,
      6.187554,
      0,
      15,
      4,
      3.118339,
      13.232040,
      14,
      1.222447,
      9.639500,
      9.734105,
      5.426236,
      13.584638,
      10.253996,
      16,
      2,
      32,
      NULL,
      57.411776,
      10.829389,
      2.450722,
      5.734332,
      NULL,
      NULL,
      87.237488,
      9,
      NULL,
      112,
      30,
      NULL,
      37,
      NULL,
      28.669283,
      25.172642,
      108,
      NULL,
      ' 9-17-1987',
      0.749781,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      1.969487,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1- 2-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-24-2003',
      NULL,
      14.541603,
      NULL,
      2.001107,
      26.487450,
      51.458098,
      22,
      45,
      86.225500,
      33,
      90,
      NULL,
      '11-24-1997',
      9.169063,
      1,
      0,
      4.657263,
      61,
      14,
      0,
      ' 0- 9-1991',
      NULL,
      5.786822,
      ' 1- 1-1981',
      1.833472,
      6.534537,
      NULL,
      3.490515,
      NULL,
      NULL,
      NULL,
      10.219483,
      NULL,
      14.177909,
      1.244916,
      3.119509,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-20-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      56.055181,
      NULL,
      23.005590,
      ' 9- 1-1983',
      0,
      NULL,
      '11-21-2000',
      NULL,
      43.453294,
      NULL,
      NULL,
      ' 3-13-1975',
      32.820891,
      0.413223,
      11,
      ' 9- 5-1974',
      NULL,
      NULL,
      NULL,
      43,
      1,
      22,
      10,
      NULL,
      93,
      27.005670,
      2,
      10.385800,
      7,
      3.609258,
      9,
      0.010999,
      0.073337,
      103,
      0,
      NULL,
      83,
      0.957078,
      4.201596,
      135.453994,
      1.972837,
      2.721800,
      314.247711,
      5,
      22,
      NULL,
      1.475855,
      48.199373,
      0,
      0,
      0.866257,
      1,
      0.341724,
      1,
      41,
      10.145487,
      39.720533,
      14,
      8,
      55.448162,
      0,
      1.372857,
      4.138810,
      1,
      NULL,
      1.271242,
      2.571746,
      NULL,
      56,
      1,
      44.730545,
      0,
      4.751619,
      0,
      29.657894,
      0.691299,
      NULL,
      11,
      6.326926,
      16,
      63,
      1,
      NULL,
      1.632568,
      9,
      NULL,
      0.137948,
      1,
      NULL,
      38,
      ' 7-15-2003',
      ' 5-25-1979',
      '10-22-1975',
      '10- 6-1986',
      ' 9-12-2001',
      NULL,
      ' 6-20-1980',
      NULL);
commit;
end;
/


