set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8834206';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3012',
      '11440344',
      '13424022',
      '22142120',
      '22002241',
      '31324111',
      '21430334',
      '10034033',
      NULL,
      '10413032',
      NULL,
      NULL,
      '00304320',
      NULL,
      '41424120',
      '30024221',
      '33341233',
      '34230334',
      '42014444',
      '40014434',
      '00441330',
      '20404313',
      '20322433',
      '04200211',
      '01144113',
      '21121044',
      '41343421',
      '42221342',
      NULL,
      '02441111',
      '11123400',
      '21141100',
      '40032024',
      '14000314',
      '10432330',
      '30331230',
      '12240241',
      '41031412',
      '03204102',
      '40121444',
      '12404040',
      '41122004',
      '41242114',
      '34043440',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4314211',
      1,
      29,
      2,
      NULL,
      '313404',
      1.351588,
      ' 6- 2-1994',
      ' 8-27-1983',
      NULL,
      NULL,
      6.665657,
      4,
      0,
      14,
      16.550176,
      8,
      20,
      1.916098,
      NULL,
      NULL,
      NULL,
      NULL,
      1.028959,
      9,
      NULL,
      NULL,
      33.675291,
      15.619049,
      NULL,
      NULL,
      14,
      2.824116,
      NULL,
      NULL,
      NULL,
      NULL,
      41.515653,
      NULL,
      36.061275,
      ' 4-23-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-27-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      24.426867,
      NULL,
      NULL,
      94.340643,
      NULL,
      NULL,
      6.388613,
      5,
      ' 4-20-1981',
      1,
      3,
      7.918119,
      26.612597,
      6.331535,
      14.487518,
      NULL,
      3.845385,
      NULL,
      NULL,
      0.315290,
      1.936596,
      17.131572,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-15-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      44.638268,
      6,
      NULL,
      ' 8-13-1989',
      NULL,
      NULL,
      ' 1-26-1993',
      12.431039,
      4,
      NULL,
      NULL,
      '11- 2-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      45.955196,
      84.112316,
      28.801123,
      14,
      16.922491,
      NULL,
      11.792197,
      4.561274,
      0.569712,
      0,
      30,
      NULL,
      1.225917,
      33,
      2.937430,
      3,
      NULL,
      NULL,
      0.624499,
      NULL,
      2.441695,
      NULL,
      NULL,
      0.450912,
      27.064015,
      2,
      0.083381,
      0,
      1.082239,
      0,
      NULL,
      45,
      NULL,
      NULL,
      14,
      50,
      58,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      22.099212,
      3.269439,
      NULL,
      1.911581,
      NULL,
      3.290783,
      33.270180,
      58.019124,
      52.495454,
      NULL,
      NULL,
      2,
      3.517322,
      9.714022,
      5,
      0.990529,
      0.346202,
      0,
      NULL,
      35.198664,
      '10- 9-1977',
      NULL,
      NULL,
      NULL,
      ' 2-12-1983',
      NULL,
      ' 4- 1-1986',
      NULL);
commit;
end;
/


