set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7901496';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '13321242',
      '14221012',
      '21141412',
      '44141123',
      '02110400',
      '20400223',
      '13113131',
      '40443413',
      '02114331',
      '41412403',
      '43102444',
      '34014423',
      '30044303',
      '23244322',
      '44144312',
      NULL,
      '11332431',
      '44422240',
      '22031131',
      NULL,
      '30401130',
      '03323222',
      '31232143',
      '00440122',
      '31323212',
      '43424300',
      '21333432',
      '10320342',
      '13303141',
      NULL,
      '04332043',
      '02014323',
      '11143323',
      '04344030',
      '20031412',
      '12003441',
      '01440321',
      NULL,
      '41210231',
      '30421111',
      '12424222',
      '11221234',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2232414',
      2,
      1,
      3,
      NULL,
      '421033',
      0.823743,
      ' 8- 4-1980',
      '10-21-1983',
      82,
      NULL,
      16.328325,
      5.967065,
      7.442608,
      12,
      3,
      7.328493,
      7.442054,
      0,
      25,
      12.255390,
      32.823867,
      17,
      19,
      3,
      11.252295,
      0,
      0.703163,
      17,
      NULL,
      NULL,
      2,
      0.653382,
      NULL,
      NULL,
      73.058750,
      23,
      NULL,
      90,
      81.567762,
      ' 7-16-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-19-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.200351,
      8,
      NULL,
      21.693247,
      50,
      102,
      6,
      ' 5-14-1988',
      20,
      1,
      NULL,
      3.467345,
      9.732305,
      3,
      11,
      4.880628,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      0.940939,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-25-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-18-1991',
      NULL,
      NULL,
      NULL,
      28,
      '10-16-1977',
      23.844586,
      1,
      59.904581,
      '10- 4-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.802260,
      1,
      72,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      87,
      1.265294,
      2.133668,
      5.231504,
      NULL,
      2,
      NULL,
      0.512359,
      NULL,
      NULL,
      NULL,
      NULL,
      1.592452,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      14,
      8.367628,
      9.927322,
      NULL,
      NULL,
      NULL,
      NULL,
      4.984056,
      6.159802,
      NULL,
      2.678671,
      0.166631,
      1,
      1.641728,
      0.962494,
      NULL,
      NULL,
      NULL,
      '10- 5-2000',
      NULL,
      ' 2-17-2000',
      NULL,
      '10- 8-1997',
      NULL);
commit;
end;
/


