set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9104210';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0234',
      '04044233',
      '22040212',
      '11143411',
      '22234313',
      '22320011',
      '10244311',
      '20042303',
      '02123304',
      '00431422',
      '00403044',
      '04023442',
      NULL,
      NULL,
      '21221230',
      '44424312',
      NULL,
      '23401231',
      '34332424',
      '23044012',
      '30224141',
      '44220142',
      NULL,
      '12002231',
      '24320242',
      '34002043',
      NULL,
      '00341030',
      NULL,
      NULL,
      '04014332',
      NULL,
      '33031344',
      '34042421',
      '33324121',
      '01133221',
      '01334101',
      '02343330',
      '31122302',
      NULL,
      '02212033',
      '10121221',
      '13013122',
      '44211030',
      NULL,
      '102',
      '44',
      NULL,
      NULL,
      '2130013',
      2.524377,
      0.236714,
      2,
      NULL,
      NULL,
      0.363484,
      ' 2-14-1988',
      NULL,
      39.330787,
      NULL,
      25,
      15,
      12.486200,
      9,
      65.060707,
      NULL,
      21,
      0,
      NULL,
      17.812018,
      NULL,
      3.908166,
      0.780642,
      14,
      8.059204,
      3.237446,
      NULL,
      NULL,
      8,
      15,
      NULL,
      19,
      1.315720,
      44,
      21.158557,
      31.521751,
      63.395696,
      71.267014,
      183.322056,
      NULL,
      27,
      NULL,
      2.944568,
      36,
      156,
      189.952468,
      ' 6-16-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      25,
      9,
      9,
      7,
      10,
      5.717457,
      ' 7-26-2002',
      0,
      0,
      205.652490,
      1.162807,
      5,
      NULL,
      1.480245,
      6,
      101.097921,
      NULL,
      NULL,
      NULL,
      ' 4- 2-1982',
      135,
      112,
      19.777223,
      NULL,
      NULL,
      17.332410,
      NULL,
      79,
      NULL,
      62,
      NULL,
      90,
      NULL,
      14,
      11.870263,
      NULL,
      0.572266,
      56.420803,
      100,
      10.504163,
      ' 1-15-1987',
      1.184831,
      NULL,
      NULL,
      4,
      9,
      19,
      14,
      3.811994,
      7,
      0,
      25,
      0.861177,
      25.471902,
      0.160388,
      2,
      15.970075,
      18,
      3.964390,
      0.093923,
      0,
      1.816470,
      '10- 3-1984',
      2,
      0,
      6.582625,
      ' 8-27-1990',
      NULL,
      12.035205,
      ' 9- 0-1990',
      39.031160,
      14,
      NULL,
      52,
      NULL,
      33.309721,
      NULL,
      1.498877,
      15.325788,
      '11- 8-1992',
      NULL,
      NULL,
      NULL,
      0,
      6.255742,
      ' 0-10-1978',
      0.014818,
      9,
      NULL,
      1,
      0,
      23.717526,
      ' 6- 1-1986',
      13.747831,
      4.007379,
      3.941495,
      ' 1-17-1994',
      1,
      176,
      '10-28-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.645889);
commit;
end;
/


