set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8805448';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2110',
      NULL,
      '11300423',
      '20202213',
      '02103401',
      NULL,
      '14210240',
      NULL,
      '30024432',
      '11231201',
      '33100140',
      '43313424',
      NULL,
      '24334022',
      '31243240',
      '14231421',
      '20033243',
      '12113012',
      '44440120',
      '22120220',
      '21310324',
      '22423343',
      '02243123',
      NULL,
      '40011231',
      '41441133',
      NULL,
      '22331324',
      '40022132',
      '00131013',
      '33444303',
      NULL,
      '32304310',
      '41403221',
      '30412333',
      '02202313',
      '20134204',
      '32234232',
      '22312011',
      NULL,
      '12232403',
      '00114304',
      '43411340',
      '41103423',
      '00000340',
      '',
      '',
      NULL,
      NULL,
      '0202033',
      NULL,
      0.627310,
      3,
      NULL,
      '224202',
      1,
      ' 3-11-1994',
      '10-29-1976',
      75.912921,
      NULL,
      19.050731,
      5.791760,
      27,
      20,
      79,
      14.307061,
      NULL,
      11.431847,
      NULL,
      NULL,
      34.277519,
      19,
      24.920047,
      NULL,
      13,
      NULL,
      NULL,
      NULL,
      13.737320,
      NULL,
      71,
      12.856725,
      NULL,
      28,
      90,
      33.353253,
      86,
      137.426583,
      NULL,
      ' 3-16-2003',
      50.148756,
      69.701556,
      4.410931,
      21.566887,
      169.094777,
      2.523282,
      ' 3- 7-2002',
      2.012959,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      7,
      0,
      1,
      1.452056,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-11-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-20-1989',
      NULL,
      64,
      39.356257,
      10,
      NULL,
      131.301037,
      88.531700,
      70,
      4.456087,
      53.796128,
      110.661541,
      4.456849,
      ' 6-13-2002',
      13,
      24.097312,
      8,
      NULL,
      37.477981,
      NULL,
      5.106225,
      ' 4- 5-1976',
      NULL,
      25.294746,
      ' 8-12-1979',
      5,
      7.152611,
      10,
      NULL,
      27.479371,
      2.188503,
      NULL,
      NULL,
      NULL,
      116,
      NULL,
      2.668547,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 1-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      56.742343,
      22,
      10.336077,
      ' 7-27-1976',
      NULL,
      NULL,
      NULL,
      3.413041,
      7,
      18.314568,
      16,
      ' 9- 9-1978',
      47,
      NULL,
      NULL,
      ' 6- 2-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      23,
      2.881870,
      NULL,
      5,
      8.680798,
      NULL,
      NULL,
      1.164774,
      1,
      9.917896,
      NULL,
      1,
      65,
      1.033156,
      5,
      76.627119,
      4.986023,
      NULL,
      145.562631,
      NULL,
      25,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.158015,
      4,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      17.984255,
      1,
      3.498457,
      1,
      17,
      4,
      16.997953,
      0.662835,
      NULL,
      0.534953,
      NULL,
      0.535146,
      0.918571,
      NULL,
      23,
      19,
      23,
      NULL,
      NULL,
      13.126536,
      NULL,
      6,
      3,
      0.856923,
      NULL,
      NULL,
      1.438627,
      0,
      NULL,
      NULL,
      ' 1-10-1995',
      ' 0- 3-1994',
      ' 9-24-2003',
      ' 0-12-1996',
      ' 0- 7-1977',
      ' 1-16-1975',
      ' 3- 2-1983',
      NULL);
commit;
end;
/


